#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2003-2005 Free Software Foundation
#
# FILE:
# FontMetrics.py
#
# DESCRIPTION:
# Class that encapsulates a postscript Font Metric (AFM) file
#
# NOTES:
#

__all__ = ['FontMetrics','CharMetrics','KernPairs','Composites']

import string
from gnue.common.utils.FileUtils import openResource


class _Encapsulation:
  def __init__(self, **params):
    self.__dict__.update(params)

  def addLine(self, line):
    stuff = line.split()
    key = stuff[0]
    val = string.join(stuff[1:],' ')
    self.add(key, val)

  def add(self, key, val):
    try:
      curr = self.__dict__[key]
      try:
        curr.append(val)
      except:
        self.__dict__[key] = [self.__dict__[key], val]
    except:
      self.__dict__[key] = val


class FontMetrics(_Encapsulation):
  def __init__(self, location):
    if hasattr(location,'read'):
      handle = location
      close = 0
    else:
      handle = openResource(location)
      close = 1

    # Parse the file
    stack = [self]
    current = self
    bootstrap = 1
    for line in handle.readlines():
      line = line.strip()

      if not len(line) or line[:7] == 'Comment' or not stack:
        continue

      if line[:3] == 'End':
        stack.pop()

      elif line[:5] == 'Start':
        if bootstrap:
          bootstrap = 0
          continue
        else:
          section = line[5:].split()[0]
          current = {'CharMetrics':  CharMetrics,
                     'KernData': KernData,
                     'KernPairs': KernPairs,
                     'Composites': Composites}[section]()


          stack[-1].add(section, current)
          stack.append(current)
      else:
        stack[-1].addLine(line)

    if close:
      handle.close()


class CharMetrics(_Encapsulation):
  pass

class KernData(_Encapsulation):
  pass

class KernPairs(_Encapsulation):
  pass

class Composites(_Encapsulation):
  pass


if __name__ == '__main__':

  import gnue.common.apps

  helvetica = FontMetrics('/usr/share/ted/afm/Helvetica.afm')

