#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2003-2004 Free Software Foundation
#
# $Id: Adapter.py 6763 2004-11-30 23:36:21Z jcater $

"""
Class that contains the base filter adapter for GNUe Reports'
"Char" markup.
"""

from gnue.reports.base.GROutputAdapter import TransformAdapter as Base
from CHParser import loadFile
from Writer import Writer


class TransformAdapter(Base):
  def __init__(self, *args, **parms):
    Base.__init__(self, *args, **parms)
    self.writer = Writer(self.parameters.get('formatter','text'))

  def open(self):
    # We need a temp file
    self.input, self.infile = self.createTempFile()
    return self.input

  def close(self):

    # We are finished with the intermediate file
    self.input.close()

    # Get a file for output from the destination adapter.
    self.writer.output = self.destination.getOutputHandle()

    report = loadFile(self.infile, initialize=True)

#    print report.dumpXML()

    self.parse(report)

#    infile.close()

    try:
      mimetype = self.parameters['mimetype']
    except:
      mimetype = self.MIMETYPE


    # Let the destination adapter do its thing
    self.destination.close(mimetype=mimetype)

    # clean up our temp files
    self.deleteTempFile(self.infile)


  def parse(self, report):
    self.writer.initialize(report)

    report.process(self.writer)

    self.writer.finalize()
