#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2004 Free Software Foundation
#
# FILE:
# UIwxpython.py
#
# DESCRIPTION:
# A wxPython based user interface driver for GNUe forms.
#
# NOTES:
#
from wxPython.wx import *

from gnue.common import events
from types import UnicodeType
from gnue.forms.GFForm import *
from gnue.forms.uidrivers._base.widgets._base import *
from gnue.forms.uidrivers.wx.common import *


#############################################################################
#############################################################################
#
# UI Objects
#
# A set of standard UI objects that allow us to move more code into UIbase
# These map generic functionality to the specific UI widget set in use by
# this driver.
#
#############################################################################
#############################################################################

#
# UIHelper
#
# Provides a UI widget set of std functions to reduce the number of functions
# require in each UIclass listed below.
#
class UIHelper(UIWidget):
  #
  # Functions limited to the wx driver
  #
  def _addToCrossRef(self, widget,gfobject, uiobject):
    id = widget.GetId()
    self._uiDriver._IdToTkObj[id]=widget
    self._uiDriver._IdToGFObj[id]=gfobject
    self._uiDriver._IdToUIObj[id]=uiobject
    widget.__origBackgroundColor = widget.GetBackgroundColour()

  def _deleteFromCrossRef(self, widget, object):
    id = widget.GetId()
    try:
      del self._uiDriver._IdToTkObj[id]
      del self._uiDriver._IdToGFObj[id]
      del self._uiDriver._IdToUIObj[id]
    except:
      pass

  #
  # Override the base UIWidget functions
  #
  def show(self):
    for widget in self.widgets:
      widget.Show(1)
      widget.Raise()

  def hide(self):
    for widget in self.widgets:
      widget.Show(0)
          
  def showModal(self):
    for widget in self.widgets:
      widget.ShowModal()

  def destroy(self):
    for widget in self.widgets:
      self.Destroy()

  def indexedFocus(self, index):
    self.widgets[index].SetFocus()

  def setValue(self, value, index=0, enabled=1):
    # These must be here or dropdown style controls
    # will get events they shouldn't and break.
    widget = self.widgets[index]
    widget.SetEvtHandlerEnabled(FALSE)

    # Check if foreign key changed
    object = self._uiDriver._IdToGFObj[widget.GetId()]
    try:
      if object.style == "dropdown" and \
          not object._field._allowedValues == widget._origAllowedValues:
        try:
          # Not in wx 2.2.x
          widget.Freeze()
        except AttributeError:
          pass
        widget._origAllowedValues = object._field._allowedValues
        widget.Clear()
        for value in object._field._allowedValuesDescr:
          widget.Append(wxEncode(value))
        widget.SetValue("")
        try:
          # Not in wx 2.2.x
          widget.Thaw()
        except AttributeError:
          pass
    except AttributeError:
      pass

    widget.SetValue(wxEncode(value))
    widget.Enable(enabled)
    widget.SetEvtHandlerEnabled(TRUE)
    if enabled:
      widget.SetBackgroundColour(widget.__origBackgroundColor)
    else:
      widget.SetBackgroundColour(self._uiDriver._disabledColour)
    widget.Refresh()

  def setCursorPosition(self, position, index=0):
    try:
      self.widgets[index].SetInsertionPoint(position)
    except AttributeError:
      pass  # For label-style entries

  def setSelectedArea(self, selection1, selection2, index=0):
    try:
      self.widgets[index].SetSelection(selection1, selection2)
    except (AttributeError, TypeError):
      pass  # For label-style & dropdown entries

  def createWidget(self, event, spacer):
    newWidget = self._createWidget(event, spacer)
    initFont(newWidget)
    if event.initialize: 
      self._addToCrossRef(newWidget,event.object,self)
    return newWidget

  def cleanup(self, object):
    for widget in self.widgets[:]:
      id = widget.GetId()
      try:
        del self._uiDriver._IdToTkObj[id]
        del self._uiDriver._IdToGFObj[id]
        del self._uiDriver._IdToUIObj[id]
      except KeyError:
        pass
      self.widgets.pop(0)
      self._deleteFromCrossRef(widget, object)
