#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2004 Free Software Foundation
#
# FILE:
# wx/MenuBar.py
#
# DESCRIPTION:
# A generic UIdriver base for common message-based GUI toolkits.
#
# NOTES:
#

import string
from wxPython.wx import *
from gnue.forms.uidrivers._commonGuiToolkit.MenuBar import MenuBar as _BaseMenuBar
from common import wxEncode

class MenuBar(_BaseMenuBar):

  # Create the menu
  def init(self): 
    self.menu = menu = wxMenuBar()
    self.container.SetMenuBar(menu)
    return menu

  # Add a (sub)menu
  def addMenu(self, name, parent):
    menu = wxMenu()
    id = wxNewId()
    if parent == self.menu:
      parent.Append(menu, name)
    else:
      parent.AppendMenu(id, name, menu)

    return menu

  # Add a menu item (action)
  # NOTE: the _skipHotKey attribute is specific to wx's MenuBar code.
  #       it is an internal workaround to a GTK+wx i18n bug.
  def addAction(self, name, parent, userAction, _skipHotkey=0):
    label = name
    hotkey = userAction.getHotKeyText()
    iconloc = userAction.getIconLocation(size="16x16")

    if hotkey and not _skipHotkey:
      label += '\t%s' % hotkey

    id = wxNewId()
    item = wxMenuItem(parent, id, wxEncode(label),
                      wxEncode(userAction.description) or '')
    
    # Set the action icon if available
    if iconloc:
      try:
        # Some caching logic for faster second/third forms
        icon = _cachedIcons[iconloc]
      except KeyError:
        icon = wxImage(iconloc, wxBITMAP_TYPE_PNG).ConvertToBitmap()
        _cachedIcons[iconloc] = icon
      try:
        item.SetBitmap(icon)
      except AttributeError:
        # Good ol' wx 2.2 $@#!@#
        pass

    try:
      parent.AppendItem(item)
    except:
      # Some i18n installations of WX don't like our hotkeys!
      # Damn GTK piece of crap
      if _skipHotkey:
        raise
      self.addAction(name, parent, userAction, _skipHotkey=1)
      return

    parent.SetLabel(id, wxEncode(label))

    event = 'request' + userAction.event
    EVT_MENU(self.driver._wxapp, id,
      lambda event, l=self.driver, e=event, f=self.form: l.dispatchEvent(e,_form=f))

    return item

  # Add a separator
  def addSeparator(self, parent):
    parent.AppendSeparator()

  # Enable a menu item
  def enableItem(self, item):
    item.Enable(1)

  # Disable a menu item
  def disableItem(self, item):
    item.Enable(0)

_cachedIcons = {}
