#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2004 Free Software Foundation
#
# FILE:
# win32/common.py
#
# DESCRIPTION:
# A PyWin32 based user interface driver for GNUe forms.
#
# NOTES:
#

import string
import win32gui, win32con, win32ui
from win32con import *
from gnue.common import events
from gnue.common.apps import GConfig
from types import UnicodeType, StringType


_idPos = 1000

def getNextId():
  global _idPos
  _idPos += 1
  return _idPos


def centerWindow(hwnd):
  desktop = win32gui.GetDesktopWindow()
  l,t,r,b = win32gui.GetWindowRect(hwnd)
  dt_l, dt_t, dt_r, dt_b = win32gui.GetWindowRect(desktop)
  center_x, center_y = win32gui.ClientToScreen( desktop, ( (dt_r-dt_l)/2, (dt_b-dt_t)/2) )
  win32gui.MoveWindow(hwnd, center_x-(r/2), center_y-(b/2), r-l, b-t, 0)


def textEncode(u_string):    
    if type(u_string)==UnicodeType:
        return u_string.encode(gConfig('textEncoding'),'replace')
    else:
        return u_string


def textDecode(string):    
    if type(string)==StringType:
        return unicode(string, gConfig('textEncoding'))
    else:
        return string
