#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2004 Free Software Foundation
#
# FILE:
# UIqt.py
#
# DESCRIPTION:
# A QT-based user interface driver for GNUe forms.
#
# NOTES:
#
import string
from gnue.common import events
from gnue.common.apps import GDebug

from gnue.forms.uidrivers.qt.common import *

from qt import *

class ScrollableWrapper(QScrollView):
  def __init__(self, uiform):
    self.uiform = uiform
    self.frame = frame = uiform.mainWindow
    self.form = form = uiform._form

    self.margin = 6
    self.spacerpane = QFrame(frame)

    QScrollView.__init__(self, self.spacerpane)

##    EVT_SIZE(self.frame, self.OnFrameSize)
    formWidth = int(form._layout.Char__width)
    formHeight = int(form._layout.Char__height)
    self.layoutSize = (0,0,formWidth*uiform._uiDriver.widgetWidth,
                      formHeight*uiform._uiDriver.widgetHeight)


    self._fitted = 0
    self._pageList = []
    try:
      self.frame.setCentralWidget(self.spacerpane)
    except AttributeError:
      pass


  def finalize(self):
    # This is the initial panel window setup during init
    # not a wxPanel set per page right after this
    w = self.pane.width()
    h = self.pane.height()

    self.spacerpane.resize(w+self.margin*2, h+self.margin*2)
    self.move(self.margin, self.margin)
    self.resize(w,h)

    # TODO: *cough* Hack!!! *cough*
    self.frame.resize(w*1.2, h*1.2)

    self.show()
##    self.fixScrollbars()


  def OnFrameSize(self, event):
    self.SetSize(self.frame.GetClientSize())
    self.fixScrollbars()

  def fixScrollbars(self):
    x1, y1 = self.frame.GetClientSizeTuple()
    x2, y2 = self.pane.GetSizeTuple()
    if x1 < x2 or y1 < y2: 
      self.SetScrollbars(5, 5, x2, y2)
    else: 
      self.SetScrollbars(0, 0, 0, 0)
    
    
     
#
# Notebook pages
#
class TabbedWrapper(ScrollableWrapper): 
  def __init__(self, *args, **parms): 
    ScrollableWrapper.__init__(self, *args, **parms)
    
    self.pane = notebook = QTabWidget(self)
    notebook.setTabPosition(_tabStyles[self.form._layout.tabbed])

    # Hack!
    w,h = self.layoutSize[2:]
    notebook.resize(w*1.1, h*1.1)
                             
    QObject.connect(notebook, SIGNAL("currentChanged(QWidget*)"), 
                    self.notebookTabHandler)
                    
    notebook.show()
    
  
  def createPage(self, object): 

##    sizer = wxBoxSizer(wxVERTICAL)  
    newWidget = QFrame(self.pane)
    newWidget.setGeometry(*self.layoutSize)
    
##    sizer.Add(newWidget, 0, wxCENTER)
##    newWidget.SetAutoLayout(1)
##    newWidget.SetSizer(sizer)
    
    self._pageList.append(newWidget)
    self.pane.addTab(newWidget,hasattr(object,'caption') and object.caption or object.name)
    self.pane.setFocusPolicy(QWidget.ClickFocus)
    
##    self.pane.SetClientSize(self.layoutSize)
##    self.fit()
    return newWidget

  def fit(self): 
    if self._fitted: return
    self.notebooksizer.Layout()
    self.notebooksizer.SetSizeHints(self.pane)
    self.SetClientSize(self.pane.GetSize())    
    self.SetClientSize(self.layoutSize)    
    self.SetSize(self.pane.GetSize())
    self.frame.SetClientSize(self.GetSize())
    self._fitted = 1
  
  def notebookTabHandler(self,qwidget):
    #object = _IdToGFObj[_eventObjToQtWindow(event).GetId()]
    action = events.Event('requestPAGE',self.pane.currentPageIndex(), _form=self.form)
    self.uiform._eventHandler(action)
  
  def setPage(self, page): 
    pageId = self._pageList.index(page)
    self.pane.setCurrentPage(pageId)
    
                                     
#
# Single pages
#
class PlainWrapper(ScrollableWrapper): 
  def __init__(self, *args, **parms): 
    ScrollableWrapper.__init__(self, *args, **parms)
    self.pane = QFrame(self)
    self.pane.setGeometry(*self.layoutSize)
    self.pane.show()
          
  def createPage(self, object): 
    newWidget = QFrame(self.pane)
    newWidget.setGeometry(*self.layoutSize)
    
    # Only show first page
    if not self._fitted:
      newWidget.show()
    else:
      newWidget.hide()
      
    self._pageList.append(newWidget)
##    self.fit()
    return newWidget

  def fit(self): 
    if self._fitted: return
    self.pane.SetClientSize(self.layoutSize)
    self.pane.Fit()
    self.SetClientSize(self.pane.GetSize())
    self.SetSize(self.pane.GetSize())
    self.frame.Fit()
    self._fitted = 1

  def setPage(self, page): 
    for p in self._pageList:
      if p != page:
        p.hide()
      else:
        p.show()

        
_tabStyles = {'left': 0, ##Top,
              'right':0, ##Top,
              'bottom':0, ##Bottom,
              'top':0, ##Top,
              }
