#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2004 Free Software Foundation
#
# FILE:
# gtk2/MenuBar.py
#
# DESCRIPTION:
# A generic UIdriver base for common message-based GUI toolkits.
#
# NOTES:
#

import string
import gtk
from gnue.forms.uidrivers._commonGuiToolkit.MenuBar import MenuBar as _BaseMenuBar
  
class MenuBar(_BaseMenuBar):

  # Create the menu
  def init(self):
    self.menu = menu = gtk.MenuBar()
    self.container.content_table.attach(menu,
                                     # X direction           Y direction
                                       0, 1,                      0, 1,
                                       gtk.EXPAND | gtk.FILL,     0,
                                       0,                         0)
    return menu

  def correctLabel(self,label):
    # TODO: remove decode step, when gettext translations are send
    # in unicode instead of local encoding
    return string.replace(unicode(label,gConfigForms('textEncoding')),'&','_')
    
  # Add a (sub)menu
  def addMenu(self, name, parent):
    menuitem = gtk.MenuItem(self.correctLabel(name))
    menu=gtk.Menu()
    menuitem.set_submenu(menu)
    parent.add(menuitem)      
    return menu
  
  # Add a menu item (action)
  def addAction(self, name, parent, userAction):
    label = name
    hotkey = userAction.getHotKeyText()
    iconloc = userAction.getIconLocation(size="16x16")

    # TODO: fix display of hotkey
    if hotkey:
      label += '\t %s' % hotkey

    item = gtk.ImageMenuItem(self.correctLabel(label)) #, userAction.description or '')
    parent.add(item)

    event = 'request' + userAction.event
    item.connect('activate',lambda event, l=self.driver, e=event, f=self.form:\
                 l.dispatchEvent(e,_form=f))

    # Set the action icon if available
    if iconloc:
      try:
        # TODO: Check if caching works, or if we have to cache pixmaps
        # Some caching logic for faster second/third forms
        icon = _cachedIcons[iconloc]
      except KeyError:
        icon = gtk.Image()
        icon.set_from_file(iconloc)        
        _cachedIcons[iconloc] = icon
      item.set_image(icon)

    return item
    
  # Add a separator
  def addSeparator(self, parent): 
    item = gtk.SeparatorMenuItem()
    parent.add(item)
    
  # Enable a menu item
  def enableItem(self, item):
    item.set_sensitive(1)
  
  # Disable a menu item
  def disableItem(self, item): 
    item.set_sensitive(0)
    

_cachedIcons = {}
