#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2004 Free Software Foundation
#
# FILE:
# UIdriver.py
#
# DESCRIPTION:
# A curses based user interface driver for GNUe forms.
#
# NOTES:
#

from gnue.common.cursing import *

from gnue.forms.uidrivers.curses.widgets._base import UIHelper

#
# UIScrollBar
#
# Widget set specific function that creates a single instance of a scroll bar used
# to navigate multiple records
#
class UIScrollBar(UIHelper):
  def _createWidget(self, event, spacer):
    object = event.object

    if object["Char:width"] > 1:
      newWidget = ScrollBar(event.container,'name',object['Char:y'],
                            object['Char:x'],object['Char:width'])
    else:
      newWidget = VScrollBar(event.container,'name',object['Char:y'],
                            object['Char:x'],object['Char:width'])
    event.container.AddControl(newWidget)
    newWidget.Init(10)  ## TODO: This should be the number of rows
    return newWidget

configuration = {
  'baseClass'  : UIScrollBar,
  'provides'   : 'GFScrollBar',
  'container'  : 0,
  }

