#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2004 Free Software Foundation
#
# FILE:
# UIdriver.py
#
# DESCRIPTION:
# A curses based user interface driver for GNUe forms.
#
# NOTES:
#

from gnue.common.cursing import *

from gnue.forms.uidrivers.curses.widgets._base import UIHelper
from gnue.forms.uidrivers.curses.common import _EVENTPROCESSOR
global _EVENTPROCESSOR

#
# UIButton
#
# Widget set specific function that creates a single instance of a button
#
class UIButton(UIHelper):
  def _createWidget(self, event, spacer):
    object = event.object
    newWidget = Button(event.container,'name',object["Char:y"]+spacer,object["Char:x"],object["Char:width"],str(object.label))
    event.container.AddControl(newWidget)
    self.__gf = object
    newWidget.SetMethod("CLICK", self.buttonHandler)
    return newWidget

  def buttonHandler(self, a1, a2, a3):
    global _EVENTPROCESSOR
    GDebug.printMesg(1,"Click!")

    _EVENTPROCESSOR(events.Event('buttonActivated',self.__gf))

configuration = {
  'baseClass'  : UIButton,
  'provides'   : 'GFButton',
  'container'  : 0,
  }
