#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2001-2004 Free Software Foundation
#
# FILE:
# GFConfig.py
#
# DESCRIPTION:
"""
Valid configuration options for forms
(appears under [forms] section in gnue.conf)
"""
# NOTES:
#

from gnue.common.formatting import GTypecast

ConfigOptions = (
  { 'Name'       : 'AutoCreate',
    'Type'       : 'Setting',
    'Comment'    : 'Create new records in blocks automagically when you hit the bottom',
    'Description': 'Create new records in blocks automagically when you hit the bottom.',
    'Typecast'   : GTypecast.boolean,
    'Default'    : True },

  { 'Name'       : 'RememberLastQuery',
    'Type'       : 'Setting',
    'Comment'    : 'Remember last query entered.',
    'Description': 'Remember last query entered. (If enabled, then the '
                 + 'last values entered for a query can be retrieved by '
                 + 'doing an Enter-Query twice)',
    'Typecast'   : GTypecast.boolean,
    'Default'    : True },

  { 'Name'       : 'DisableSplash',
    'Type'       : 'Setting',
    'Comment'    : 'Disable the startup splashscreen.',
    'Description': 'Disable the startup splashscreen.',
    'Typecast'   : GTypecast.boolean,
    'Default'    : False },

  { 'Name'       : 'AllowNumericFormulas',
    'Type'       : 'Setting',
    'Comment'    : 'Remember last query entered.',
    'Description': 'Remember last query entered. (If enabled, then the '
                 + 'last values entered for a query can be retrieved by '
                 + 'doing an Enter-Query twice)',
    'Typecast'   : GTypecast.boolean,
    'Default'    : True },

  { 'Name'       : 'EnterIsNewLine',
    'Type'       : 'Setting',
    'Comment'    : 'Treat enter as shift-enter in multi-line text boxes.',
    'Description': 'If set then the enter key inputs a carrage return '
                 + 'and line feed in mutli-line text boxes.',
    'Typecast'   : GTypecast.boolean,
    'Default'    : True },

  { 'Name'       : 'CacheDetailRecords',
    'Type'       : 'Setting',
    'Comment'    : 'Enable caching of detail data',
    'Description': 'Enable caching of detail data\n'
                 + 'If set to true (default), then always cache '
                 + 'detail data in a master/detail set. The benefits '
                 + 'of this method is performance. The downsize to '
                 + 'this method is that records are cached so any '
                 + 'changes made elsewhere are not reflected in the '
                 + 'cached records.\n'
                 + 'If set to false, then only cache detail data if '
                 + 'it has unposted changes. The benefits of this '
                 + 'method are that if another user modifies data '
                 + 'and saves, then it will be available to your '
                 + 'form much quicker.',
    'Typecast'   : GTypecast.boolean,
    'Default'    : True },

  { 'Name'       : 'DateEditMask',
    'Type'       : 'Setting',
    'Comment'    : 'Mask for editing date/time fields (without qoutes).',
    'Description': 'Mask for editing date/time fields (without quotes).',
    'Typecast'   : GTypecast.text,
    'Default'    : '%m/%d/%Y' },

  { 'Name'       : 'DateMask',
    'Type'       : 'Setting',
    'Comment'    : 'Mask for viewing date/time fields (without quotes).',
    'Description': 'Mask for viewing date/time fields (without quotes).',
    'Typecast'   : GTypecast.text,
    'Default'    : '%m/%d/%y' },

  { 'Name'       : 'DateEditMask_Time',
    'Type'       : 'Setting',
    'Comment'    : 'Mask for editing date/time fields (without qoutes).',
    'Description': 'Mask for editing date/time fields (without quotes).',
    'Typecast'   : GTypecast.text,
    'Default'    : '%h:%i:%s' },

  { 'Name'       : 'DateMask_Time',
    'Type'       : 'Setting',
    'Comment'    : 'Mask for viewing date/time fields (without quotes).',
    'Description': 'Mask for viewing date/time fields (without quotes).',
    'Typecast'   : GTypecast.text,
    'Default'    : '%h:%i:%s' },

  { 'Name'       : 'DateEditMask_Timestamp',
    'Type'       : 'Setting',
    'Comment'    : 'Mask for editing date/time fields (without qoutes).',
    'Description': 'Mask for editing date/time fields (without quotes).',
    'Typecast'   : GTypecast.text,
    'Default'    : '%m/%d/%Y %h:%i:%s' },

  { 'Name'       : 'DateMask_Timestamp',
    'Type'       : 'Setting',
    'Comment'    : 'Mask for viewing date/time fields (without quotes).',
    'Description': 'Mask for viewing date/time fields (without quotes).',
    'Typecast'   : GTypecast.text,
    'Default'    : '%m/%d/%Y %h:%i:%s' },

  { 'Name'       : 'TextEditMask',
    'Type'       : 'Setting',
    'Comment'    : 'Mask for editing date/time fields (without qoutes).',
    'Description': 'Mask for editing date/time fields (without quotes).',
    'Typecast'   : GTypecast.text,
    'Default'    : '' },

  { 'Name'       : 'TextMask',
    'Type'       : 'Setting',
    'Comment'    : 'Mask for viewing date/time fields (without quotes).',
    'Description': 'Mask for viewing date/time fields (without quotes).',
    'Typecast'   : GTypecast.text,
    'Default'    : '' },

  { 'Name'       : 'NumberEditMask',
    'Type'       : 'Setting',
    'Comment'    : 'Mask for editing number fields (without qoutes).',
    'Description': 'Mask for editing number fields (without quotes).',
    'Typecast'   : GTypecast.text,
    'Default'    : '#0.#' },

  { 'Name'       : 'NumberMask',
    'Type'       : 'Setting',
    'Comment'    : 'Mask for viewing number fields (without quotes).',
    'Description': 'Mask for viewing number fields (without quotes).',
    'Typecast'   : GTypecast.text,
    'Default'    : '#,##0.#' },

  { 'Name'       : 'NumberEditMask_Money',
    'Type'       : 'Setting',
    'Comment'    : 'Mask for editing number fields (without qoutes).',
    'Description': 'Mask for editing number fields (without quotes).',
    'Typecast'   : GTypecast.text,
    'Default'    : '#0.00' },

  { 'Name'       : 'NumberMask_Money',
    'Type'       : 'Setting',
    'Comment'    : 'Mask for viewing number fields (without quotes).',
    'Description': 'Mask for viewing number fields (without quotes).',
    'Typecast'   : GTypecast.text,
    'Default'    : '\\$#,##0.00' },

  { 'Name'       : 'NumberEditMask_Integer',
    'Type'       : 'Setting',
    'Comment'    : 'Mask for editing number fields (without qoutes).',
    'Description': 'Mask for editing number fields (without quotes).',
    'Typecast'   : GTypecast.text,
    'Default'    : '#0' },

  { 'Name'       : 'NumberMask_Integer',
    'Type'       : 'Setting',
    'Comment'    : 'Mask for viewing number fields (without quotes).',
    'Description': 'Mask for viewing number fields (without quotes).',
    'Typecast'   : GTypecast.text,
    'Default'    : '#,##0' },

  { 'Name'       : 'Encoding',
    'Type'       : 'Setting',
    'Comment'    : 'Hack for db encoding',
    'Description': 'Hack for db encoding.',
    'Typecast'   : GTypecast.text,
    'Default'    : 'DEFAULT' },

  { 'Name'       : 'formFontEncoding',
    'Type'       : 'Setting',
    'Comment'    : 'Deprecated, use "textEncoding" in [common] section instead.',
    'Description': 'Font in forms encoding. Like iso8859-1, iso8859-13.',
    'Typecast'   : GTypecast.text,
    'Default'    : 'iso8859-1' },


  { 'Name'       : 'SplashScreenPNG',
    'Type'       : 'Setting',
    'Comment'    : 'Location of startup graphic (PNG format)',
    'Description': 'Location of startup graphic (PNG format)',
    'Typecast'   : GTypecast.text,
    'Default'    : 'gnue-splash.png' },

  #
  # Toolbar Icons
  #

  { 'Name'       : 'tb_commit',
    'Type'       : 'Setting',
    'Comment'    : 'Location of "Commit" toolbar icon (PNG format)',
    'Description': 'Location of "Commit" toolbar icon (PNG format)',
    'Typecast'   : GTypecast.text,
    'Default'    : 'tb_save.png' },
  { 'Name'       : 'tb_insert',
    'Type'       : 'Setting',
    'Comment'    : 'Location of "Insert" toolbar icon (PNG format)',
    'Description': 'Location of "Insert" toolbar icon (PNG format)',
    'Typecast'   : GTypecast.text,
    'Default'    : 'tb_new.png' },
  { 'Name'       : 'tb_rollback',
    'Type'       : 'Setting',
    'Comment'    : 'Location of "Rollback" toolbar icon (PNG format)',
    'Description': 'Location of "Rollback" toolbar icon (PNG format)',
    'Typecast'   : GTypecast.text,
    'Default'    : 'tb_undo.png' },
  { 'Name'       : 'tb_delete',
    'Type'       : 'Setting',
    'Comment'    : 'Location of "Delete" toolbar icon (PNG format)',
    'Description': 'Location of "Delete" toolbar icon (PNG format)',
    'Typecast'   : GTypecast.text,
    'Default'    : 'tb_delete.png' },
  { 'Name'       : 'tb_previous',
    'Type'       : 'Setting',
    'Comment'    : 'Location of "Previous Record" toolbar icon (PNG format)',
    'Description': 'Location of "Previous Record" toolbar icon (PNG format)',
    'Typecast'   : GTypecast.text,
    'Default'    : 'tb_up_arrow.png' },
  { 'Name'       : 'tb_next',
    'Type'       : 'Setting',
    'Comment'    : 'Location of "Next Record" toolbar icon (PNG format)',
    'Description': 'Location of "Next Record" toolbar icon (PNG format)',
    'Typecast'   : GTypecast.text,
    'Default'    : 'tb_down_arrow.png' },
  { 'Name'       : 'tb_first',
    'Type'       : 'Setting',
    'Comment'    : 'Location of "First Record" toolbar icon (PNG format)',
    'Description': 'Location of "First Record" toolbar icon (PNG format)',
    'Typecast'   : GTypecast.text,
    'Default'    : 'tb_top.png' },
  { 'Name'       : 'tb_last',
    'Type'       : 'Setting',
    'Comment'    : 'Location of "Last Record" toolbar icon (PNG format)',
    'Description': 'Location of "Last Record" toolbar icon (PNG format)',
    'Typecast'   : GTypecast.text,
    'Default'    : 'tb_bottom.png' },
  { 'Name'       : 'tb_jump',
    'Type'       : 'Setting',
    'Comment'    : 'Location of "Jump to Record" toolbar icon (PNG format)',
    'Description': 'Location of "Jump to Record" toolbar icon (PNG format)',
    'Typecast'   : GTypecast.text,
    'Default'    : 'tb_jump-to.png' },
  { 'Name'       : 'tb_query_prep',
    'Type'       : 'Setting',
    'Comment'    : 'Location of "Prepare Query" toolbar icon (PNG format)',
    'Description': 'Location of "Prepare Query" toolbar icon (PNG format)',
    'Typecast'   : GTypecast.text,
    'Default'    : 'tb_search.png' },
  { 'Name'       : 'tb_query',
    'Type'       : 'Setting',
    'Comment'    : 'Location of "Prepare Query" toolbar icon (PNG format)',
    'Description': 'Location of "Prepare Query" toolbar icon (PNG format)',
    'Typecast'   : GTypecast.text,
    'Default'    : 'tb_exec.png' },
  { 'Name'       : 'tb_insert',
    'Type'       : 'Setting',
    'Comment'    : 'Location of "Execute Query" toolbar icon (PNG format)',
    'Description': 'Location of "Execute Query" toolbar icon (PNG format)',
    'Typecast'   : GTypecast.text,
    'Default'    : 'tb_new.png' },
  { 'Name'       : 'tb_exit',
    'Type'       : 'Setting',
    'Comment'    : 'Location of "Exit" toolbar icon (PNG format)',
    'Description': 'Location of "Exit" toolbar icon (PNG format)',
    'Typecast'   : GTypecast.text,
    'Default'    : 'tb_exit.png' },
  { 'Name'       : 'loginPNG',
    'Type'       : 'Setting',
    'Comment'    : 'Location of GNUe login logo (PNG format)',
    'Description': 'Location of GNUe login logo (PNG format)',
    'Typecast'   : GTypecast.text,
    'Default'    : 'gnue.png' },
  { 'Name'       : 'loginBMP',
    'Type'       : 'Setting',
    'Comment'    : 'Location of GNUe login logo (BMP format)',
    'Description': 'Location of GNUe login logo (BMP format)',
    'Typecast'   : GTypecast.text,
    'Default'    : 'gnue.bmp' },

  { 'Name'       : 'widgetHeight',
    'Type'       : 'Setting',
    'Comment'    : "The default height of widgets for widgets that don't specify height in .gfd file",
    'Description': "The default height of widgets for widgets that don't specify height in .gfd file",
    'Typecast'   : GTypecast.whole,
    'Default'    : 1 },

  { 'Name'       : 'widgetWidth',
    'Type'       : 'Setting',
    'Comment'    : "The default width of widgets for widgets that don't specify width in .gfd file",
    'Description': "The default width of widgets for widgets that don't specify width in .gfd file",
    'Typecast'   : GTypecast.whole,
    'Default'    : 10 },

  { 'Name'       : 'fixedWidthFont',
    'Type'       : 'Setting',
    'Comment'    : 'Set to true if wxWidgets clients should use a fixed width font',
    'Description': 'Set to true if wxWidgets clients should use a fixed width font',
    'Typecast'   : GTypecast.boolean,
    'Default'    : True },

  { 'Name'       : 'pointSize',
    'Type'       : 'Setting',
    'Comment'    : 'If fixedWidthFont is set to true, then this is the point size used for fonts.',
    'Description': 'If fixedWidthFont is set to true, then this is the point size used for fonts.',
    'Typecast'   : GTypecast.whole,
    'Default'    : 14 },

  { 'Name'       : 'checkboxTrue',
    'Type'       : 'Setting',
    'Comment'    : 'The default value stored in the database for True values',
    'Description': 'The default value stored in the database for True values',
    'Typecast'   : GTypecast.text,
    'Default'    : 'Y' },

  { 'Name'       : 'checkboxFalse',
    'Type'       : 'Setting',
    'Comment'    : 'The default value stored in the database for false values',
    'Description': 'The default value stored in the database for false values',
    'Typecast'   : GTypecast.text,
    'Default'    : 'N' },

  { 'Name'       : 'DropdownSeparator',
    'Type'       : 'Setting',
    'Comment'    : 'Text used to concatenation dropdown descriptions',
    'Description': 'Text used to concatenation dropdown descriptions (when multiple description fields are used)',
    'Typecast'   : GTypecast.text,
    'Default'    : ', ' },
  { 'Name'       : 'DefaultUI',
    'Type'       : 'Setting',
    'Comment'    : 'The default user interface driver to use if not specified on the command line.',
    'Description': 'The default user interface driver to use if not specified on the command line.',
    'Typecast'   : GTypecast.text,
    'Default'    : 'wx' },

  #
  # Do not alter below here unless you really, really want to (and you know what you are doing)
  #

#  { 'Name'       : '_msgNOTSAVED',
#    'Type'       : 'Setting',
#    'Comment'    : 'Message to display when data has not been saved',
#    'Description': 'Message to display when data has not been saved',
#    'Typecast'   : GTypecast.text,
#    'Default'    : 'Data not saved. Commit or rollback changes.' },

#  { 'Name'       : 'DEBUG',
#    'Type'       : 'Setting',
#    'Comment'    : 'Message to display when data has not been saved',
#    'Description': 'Message to display when data has not been saved',
#    'Typecast'   : GTypecast.text,
#    'Default'    : 'Data not saved. Commit or rollback changes.' },

#  { 'Name'       : '_msgDETAILNOTSAVED',
#    'Type'       : 'Setting',
#    'Comment'    : 'Message to display when detail data has not been saved',
#    'Description': 'Message to display when detail data has not been saved',
#    'Typecast'   : GTypecast.text,
#    'Default'    : "This record's detail information is not saved." },

  { 'Name'       : 'BorderPercentage',
    'Type'       : 'Setting',
    'Comment'    : 'Fudge factor for altering widget size',
    'Description': 'Fudge factor for altering widget size',
    'Typecast'   : GTypecast.number,
    'Default'    : 100.0 },

  { 'Name'       : 'TextPercentage',
    'Type'       : 'Setting',
    'Comment'    : 'Fudge factor for altering text size',
    'Description': 'Fudge factor for altering text size',
    'Typecast'   : GTypecast.number,
    'Default'    : 100.0 },

  { 'Name'       : 'AsterickWildcard',
    'Type'       : 'Setting',
    'Comment'    : 'Use asterick (*) for wildcards in addition to percent (%)',
    'Description': 'Use asterick (*) for wildcards in addition to percent (%)',
    'Typecast'   : GTypecast.boolean,
    'Default'    : True },

)
