#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2004 Free Software Foundation
#
# FILE:
# GFClient.py
#
# DESCRIPTION:
"""
Command line client startup file that parses args,
imports the required UI, configures the controling
GFInstance and passes control to it.
"""
# NOTES:
#

import os, sys

from gnue.common.apps.GClientApp import *
from gnue.common.apps import GDebug
from gnue.common.apps import GConfig
from gnue.common.datasources import GDataObjects, GConnections
from gnue.common.utils.FileUtils import dyn_import
from gnue.common.logic.language import CompileError

from gnue.forms import VERSION
from gnue.forms.GFInstance import *
from gnue.forms.GFConfig import ConfigOptions
from gnue.forms.uidrivers._base import Exceptions

class GFClient(GClientApp):
  #
  # GClientApp() overrides
  #
  VERSION = VERSION
  COMMAND = "gnue-forms"
  NAME = "GNUe Forms"
  USAGE = GClientApp.USAGE + " file"
  SUMMARY = \
     _("GNUe Forms is the primary user interface to the GNU Enterprise system.")
  USE_DATABASE_OPTIONS = 1

  def __init__(self, connections=None):

    self.addCommandOption('user_interface', 'u', 'interface',
          argument="ui", category="ui",
          help=_("The name of the user interface to use to display your form. "
                  "For a list of interfaces, use the --help-ui options."))

    self.addCommandOption('help-ui', action=self.__listUIs,category="ui",
          help=_("Prints a list of user interfaces that forms supports."))

    self.addCommandOption('no-splash','s', category="ui",
          help=_('Disables the splash screen'))

    GClientApp.__init__(self, connections,'forms',ConfigOptions)
    self.configurationManager.registerAlias('gConfigForms', 'forms')

  #
  # Run the client application
  #
  def run(self):

    #
    # Initialize user interface
    #
    self.ui_type = self.OPTIONS['user_interface']
    if self.ui_type:
      SPECIFIC_UI = True
    else:
      SPECIFIC_UI = False
      self.ui_type = gConfigForms('DefaultUI')

    while 1:
      try:
        self._ui = dyn_import("gnue.forms.uidrivers.%s" % (self.ui_type))
        break
      except ImportError, err:
        GDebug.printMesg(1,_("Unknown UI Driver:")+" %s" % self.ui_type)
        GDebug.printMesg(1,err)
        try:
          self._ui = dyn_import("%s" % (self.ui_type.replace('/','.')))
          break
        except ImportError, err:
          raise  # TODO: TEMPORARY
          GDebug.printMesg(1,_("Unknown UI driver")+" %s" % self.ui_type)
          GDebug.printMesg(1,err)

          self.handleStartupError(_("Unknown UI driver specified: %s") % self.ui_type)

      except Exceptions.UIException, err:

        # If user specified a specific UI, don't cycle...
        if SPECIFIC_UI:
          self.handleStartupError('Unable to load UI driver: %s' % err)

        if self.ui_type != 'curses':
          self.ui_type = 'curses'
        else:
          self.handleStartupError(_("Unable to load any valid UI drivers.  Aborting."))

    if hasattr(self._ui,'handleStartupError') and not self.OPTIONS['debug-level']:
      self.handleStartupError = self._ui.handleStartupError

##    if hasattr(self._ui,'handleUncaughtException'):
##      sys._orig_excepthook = sys.excepthook
##      sys.excepthook = self._ui.handleUncaughtException


    #
    # assign form file from 1st free argument
    #
    try:
      formfile = self.ARGUMENTS[0]
    except:
      try:
        basename=os.path.basename(sys.argv[0])
        # If no form specified, then see if this is a symlinked form definition
        if not (string.split(string.lower(basename),'.')[0] in ('gnue-forms','gfclient')):
          formfile = os.path.join (
            GConfig.getInstalledBase('forms_appbase','common_appbase','install_prefix'),
            gConfigForms('FormDir'),basename+".gfd" )
        else:
          raise IndexError
      except IndexError:
        self.handleStartupError (_("No Forms Definition File Specified."))

    #
    # Get the user supplied parameters
    #
    userParameters = self.getCommandLineParameters(self.ARGUMENTS[1:])


    if gConfigForms('disableSplash') == True:
      self.disableSplash = True
    else:
      self.disableSplash = self.OPTIONS['no-splash']

    #
    # Assign the proper login handler based upon the user interface choice
    #
    self.getConnectionManager().setLoginHandler(self._ui.UILoginHandler())

    #
    # Create the Instance that will control the loaded form(s)
    #
    instance = GFInstance(self,
                          connections=self.connections, ui=self._ui,
                          disableSplash=self.disableSplash,
                          parameters=userParameters)

    instance.addFormFromFile(formfile)
    instance.addDialogs()
    try:
      instance.activate()
    except CompileError, msg:
      self.handleStartupError(msg)

  def __listUIs(self):
    self.printHelpHeader()
    print _("The following interfaces are supported by GNUe Forms. You can select an\n"
            "interface via the --interface option.")
    print
    print _("To view general help, run this command with the --help option.")
    print
    print _('User interface command line options:')
    print self.buildHelpOptions("ui")
    # TODO: This should be automated
    print "Available user interfaces:"
    print "   wx       wxPython-based graphical interface"
    print "   gtk2     GTK2-based graphical interface"
    print "   qt       QT3-based graphical interface"
    print "   win32    Native Windows graphical interface"
    print "   curses   Text-based interface that uses ncurses"
    self.printHelpFooter()
    sys.exit()

if __name__ == '__main__':
  GFClient().run()


