# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2005 Free Software Foundation
#
# $Id: widget.py 6930 2005-02-01 19:21:39Z btami $
#
# DESCRIPTION:
# A PyWin32 based user interface driver for GNUe forms.
#
# NOTES:
#
import string, struct

import win32api, win32gui, win32con, commctrl

from gnue.forms.uidrivers.win32.common import *
from gnue.forms.uidrivers.win32.widgets._base import UIHelper, Win32Window
from gnue.forms.uidrivers.win32.MenuBar import MenuBar
from gnue.forms.uidrivers.win32.ToolBar import ToolBar
import wrappers


#
# UIForm
#
# Widget set specific function that creates a single instance of a Form widget
#

class UIForm(UIHelper):

  def __init__(self, event):
    self._uiPageList=[]
    UIHelper.__init__(self, event)


  def _createWidget(self, event, spacer):
    object = event.object
    #
    # Size based upon the form definition
    #

    formWidth = int(self._form._layout.Char__width)
    formHeight = int(self._form._layout.Char__height)
    self._visibleSize = (formWidth*self._uiDriver.widgetWidth,
                      formHeight*self._uiDriver.widgetHeight)

    self._formSize = formSize = (formWidth*self._uiDriver.widgetWidth,
                      formHeight*self._uiDriver.widgetHeight)


    # Create the main window.
    if self._form._features['GUI:TOOLBAR:SUPPRESS']:
      self.buttonbarWidth = 0
      self.buttonbarHeight = 0
    else:
      # TODO: calculate
      self.buttonbarWidth = 14*(24+8) + 5*7 #buttons and separators
      self.buttonbarHeight = 24+8

    if object._layout.tabbed != 'none':
      self.tabHeight = self._uiDriver.widgetHeight + 8
    else:
      self.tabHeight = 0

    if self._form.style == 'dialog':
      style = win32con.WS_POPUP | win32con.WS_CAPTION | win32con.WS_CLIPCHILDREN | win32con.WS_SYSMENU #| win32con.WS_OVERLAPPED
    else:
      style = win32con.WS_OVERLAPPEDWINDOW | win32con.WS_CLIPCHILDREN
    styleEx = 0
    self.mainWindow = Win32Window(self._uiDriver, styleEx, self._uiDriver._wndclass, textEncode(self._form.title),
      style, win32con.CW_USEDEFAULT, 0,
      max(formWidth*self._uiDriver.widgetWidth+20, self.buttonbarWidth),
      formHeight*self._uiDriver.widgetHeight+self.buttonbarHeight+self.tabHeight+90,
      0)

    self._uiDriver._win32app._MainWindowList.append(self.mainWindow)

    if self._form.style == 'dialog':
      centerWindow(self.mainWindow.GetHwnd())

    # The window in which pages will be rendered
    if object._layout.tabbed != 'none':
      self._wrapper = wrappers.TabbedWrapper(self)
    else:
      self._wrapper = wrappers.PlainWrapper(self)

    newWidget = self._wrapper.pane
    self._containerToolkitWidget = newWidget

    # Add the menu
    if not self._form._features['GUI:MENUBAR:SUPPRESS']:
      MenuBar(self._uiDriver, self.mainWindow, self._form)

    # and the Toolbar
    if not self._form._features['GUI:TOOLBAR:SUPPRESS']:
      ToolBar(self._uiDriver, self.mainWindow, self._form)


    # and the Statusbar
    if not self._form._features['GUI:STATUSBAR:SUPPRESS']:
      hinst = win32api.GetModuleHandle(None)
      style = win32con.WS_CHILD | win32con.WS_VISIBLE | commctrl.SBARS_SIZEGRIP
      styleEx = 0
      self.statusBar = Win32Window(self._uiDriver, styleEx, commctrl.STATUSCLASSNAME, "",
        style, 0, 0, 0, 0,
        self.mainWindow, getNextId(), hinst)
      x=formWidth*self._uiDriver.widgetWidth
      statwidths = struct.pack("iiiii",x-75-75-50-50,x-75-75-50,x-75-75,x-75,x)
      win32gui.SendMessage(self.statusBar.GetHwnd(), commctrl.SB_SETPARTS, 5, statwidths)
      win32gui.SendMessage(self.statusBar.GetHwnd(), win32con.WM_SIZE, 0, 0)
      self.mainWindow._statusBar = self.statusBar
    self._eventHandler = event.eventHandler

    self._wrapper.finalize()

    return newWidget

  #
  # gotoPage
  #
  # Makes the requested page visible while hiding the others
  #
  def gotoPage(self,page):
    self._wrapper.setPage(page.widgets[0])
    
      
  #
  # _setStatusBar
  #
  def _setStatusBar(self,tip, statusValue, insertValue, currentRecord, maxRecord, currentPage, maxPage):
    if not hasattr (self, 'statusBar'):
      return
      
    if tip != None:
      win32gui.SendMessage(self.statusBar.GetHwnd(), commctrl.SB_SETTEXT, 0, textEncode(tip))

    if statusValue:
      win32gui.SendMessage(self.statusBar.GetHwnd(), commctrl.SB_SETTEXT, 1, textEncode(statusValue))

    if insertValue:
      win32gui.SendMessage(self.statusBar.GetHwnd(), commctrl.SB_SETTEXT, 2, textEncode(insertValue))

    if currentRecord and  maxRecord:
      win32gui.SendMessage(self.statusBar.GetHwnd(), commctrl.SB_SETTEXT, 3, string.strip("%s/%s" % (currentRecord,maxRecord)))

    if currentPage and  maxPage:
      win32gui.SendMessage(self.statusBar.GetHwnd(), commctrl.SB_SETTEXT, 4, string.strip("%s/%s" % (currentPage,maxPage)))

    return


  def show(self):
    self.mainWindow.Show()


  def showModal(self):
    self.mainWindow.Show()

    for window in self._uiDriver._win32app._MainWindowList:
      window.Enable(0)

    for key in self._uiDriver._formNameToUIForm.keys():
      if self._form.name == key:
        self._uiDriver._formNameToUIForm[key].mainWindow.Enable(1)

    win32gui.PumpMessages()

