#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2005 Free Software Foundation
#
# FILE:
# EventAware.py
#
# DESCRIPTION:
#
# NOTES:
#

#
# Base for an object that sends and receives events
#
class EventAware:
  """
  The base class for an object that sends and receives events

  Sample Usage::

    from gnue.common import events
    class myClass(events.EventAware):
      def __init__(self)
        self.eventController = events.EventController()
        events.EventAware.__init__(self, self.eventController)
        self.registerEventListeners( {
                             'myEvent1'           : self.eventOneHandler,
                             'myEvent2'           : self.eventTwoHandler,
                             })
    
      def eventOneHandler(self, event)
        print "I'm an event named ", event.getEvent()
    
      def eventTwoHandler(self, event)
        print "My event is named ", event.getEvent()

  """

  def __init__(self, controller):
    self.__controller = controller
    self.dispatchEvent = controller.dispatchEvent
    self.registerEventListeners = controller.registerEventListeners

  def __del__(self):
    self.__controller = None
    self.dispatchEvent = None
    self.registerEventListeners = None
