#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2003-2005 Free Software Foundation
#
# FILE:
# pyro/ClientAdapter.py
#
# DESCRIPTION:
# Set of classes that implement the pyro client adapter for GNUe Comm.
#
# NOTES:
# Requires pyro from  http://sourceforge.net/Projects/pyro
#
# Client Parameters:
#
#    url         The complete URI address of the XML-RPC service.
#                e.g, url="https://www.domain.com:9876/service.php"
#    ..or..
#    transport   The service transport (either "http" or "https")
#    host        The hostname or IP address of the service
#    port        The port that the service is located on
#

from gnue.common.rpc import client
from gnue.common.rpc.drivers import Base
from gnue.common.apps import GConfig, GDebug, errors
from gnue import paths

import string, sys

def __initplugin__ ():
  try:
    import Pyro.naming, Pyro.core, Pyro.protocol
  
  except ImportError:
    tmsg = _("\nUnable to load pyro. To use the Pyro interface, \n"
             "please install xmlrpc from:\n"
             "    http://sourceforge.net/projects/pyro "
             "the appropriate DEBIAN package is python-pyro.deb")
    raise GComm.AdapterInitializationError, tmsg


##############################################################################
#
# ClientAdapter
#
class ClientAdapter(Base.Client):

  def __init__(self, params):

    self._timeout = 1.0
    
    #
    # check for the correct parameters
    #
    
    try:

      #
      #  test for an url parameter
      # 
      try:
        url = params['url']
        if not len(url):
          raise KeyError

        # split url into server + host + path parts
        import urlparse
        
        transport, netloc, path, params, query, fragment = \
                   urlparse.urlparse(url)
        host, port=split(netloc,':',1)
        
      except KeyError:
        #
        #  transport parameter
        #
        try:
          transport = params['transport']
        except KeyError:
          transport = 'http'

        if (transport!='http'):
           tmsg = _("py-xmlrpc just support http as a transport. "
                    "If you need https please have a look at the "
                    "'pw_xmlrpc' adapter.")
           raise GComm.AdapterConfigurationError,  tmsg
        #
        #   path parameter
        #
        try:
          path = params['path']
        except KeyError:
          path = '/'

        #
        #   port parameter
        #
        try:
          port = params['port']          
        except KeyError:
          port = 8765
        
          
        #
        #   host parameter
        #
        try:
          host = params['host']
        except KeyError:
          host = 'localhost'

          
      try:
        self._url = "%s://%s:%s%s" % \
                    ( transport, params['host'], port,path )
      except:
        pass
        
      # setLoglevel
      if hasattr(params,'loglevel'):
        pass
      
      # care for non-integer port settings
      if type(port)!=type(12):
        port=string.atoi(port)

      self.pyro_group=':GComm'

      # initialize the client and set the default namespace group
      Pyro.core.initClient()
      Pyro.config.PYRO_NS_DEFAULTGROUP=self.pyro_group

      locator = Pyro.naming.NameServerLocator()
      print 'Searching Naming Service...',
      self.ns = locator.getNS()
      print ''
      print 'Naming Service found at',self.ns.URI.address,'('+\
            (Pyro.protocol.getHostname(self.ns.URI.address) \
             or '??')+') port',self.ns.URI.port
      
    except KeyError:
      tmsg = _("To use Pyro, you must either specify a 'url' or\n"
               "a 'host' and 'port' setting.")
      raise GComm.AdapterConfigurationError,  tmsg
    except:
      tmsg = u_("Unable to initialize the Pyro interface at %s") % url
      raise GComm.AdapterInitializationError, tmsg


  def request(self, service, params={}):
    # resolve the Pyro object
    print "Service: %s " % service
    print 'binding to object',service
    try:
      URI=self.ns.resolve(service+'.self')
      print 'URI:',URI
    except Pyro.core.PyroError,x:
      print 'Couldn\'t bind object (%s), nameserver says: %s' % (service,x)
      raise SystemExit
    
    return Pyro.core.getProxyForURI(URI)
    #return Pyro.core.getAttrProxyForURI(URI)
  
  def close(self):
    # do a cleanup of the proxy objects and the object stubs
    # on the XMLRPC server side

    # 1. close the proxy objects for services (static, client only)
    self._baseproxy=None    
    
    # 2. close the proxy objects for objects (dynamic, client+server)
    for i in self._objectProxys:
      i._close()      
    self._objectProxys=[] 
    
    # close the client it self
    self.ns=None    

  # just in case the user forgot to delete some objects
  def __del__(self):
    if self.ns!=None:
      self.close()
    Base.Client.__del__()


  def runMethod(self, method, *args, **params):
    __args = [typeconv.python_to_rpc (arg, client.InvalidParameter)
              for arg in args]

    # TODO: Add type conversion for **params 

    # to_call = getattr (self.__proxy, method);
        
    if 1==1: # try:
          print 'binding to object',method
          try:
            URI=self.ns.resolve(method)
            print 'URI:',URI
          except Pyro.core.PyroError,x:
            print 'Couldn\'t bind object for method %s, nameserver says: %s' % (method,x)
            raise SystemExit
    
          obj = Pyro.core.getAttrProxyForURI(URI)
          print obj
          result=obj(args)

    if 0: #except:      
      msg="Error: %s" % (sys.exc_value,)
      
      print 
      print "********************************************\n"
      print msg,"\n\n"
      print "********************************************"
      sys.exit(0)
           
    #  result = to_call (*__args, **params)
    #except xmlrpclib.Fault, e:
    #  (exType, exName, exMessage, exDetail) = string.split (e.faultString,
    #                                                        u'\x91')
    #  raise errors.RemoteError, (exType, exName, exMessage, exDetail)

    # check, if an object handle is sent
    # TODO: make a better check
    if type(result)==type("String") and len(result)==40 :

      # create an proxy for this handle
      return self._createproxy ("[%s]" % result)

    else:
      return typeconv.rpc_to_python (result, client.InvalidParameter)




##############################################################################
#
# ProxyObject
#
class _ProxyObject(Base.ProxyObject):

  def __call__(self, *args, **params):
    gDebug (3, "%s (%s)" \
            % (self.__service,
               string.join ([repr (x) for x in args] + \
                          ["%s = %s" % (x [0], repr (x [1])) \
                           for x in params.items ()], ', ')))
    print self.__parent
    #if not hasattr(self,'__parent'):
    #  print "The object '%s' can't be called" % self.__service
    #  return
    if not hasattr(self.__parent,'__pyrobind'):
      try:
        URI=self.__adapter.ns.resolve(self.__parent.__service+'.self')
      except Pyro.core.PyroError,x:
        print 'Couldn\'t bind object %s, nameserver says: %s' % (string.join(self._parent._attrPath,'.')+'.self',x)
        raise SystemExit      
      self.__parent.__pyrobind = Pyro.core.getProxyForURI(URI)
    
    return getattr(self.__parent.__pyrobind, self.__service)(*args, **params)

  # TODO: Create new getattr/setattr commands
  # ---------------------------------------------------------------------------
  # Get a (proxy) method
  # ---------------------------------------------------------------------------

  def __getattr__ (self, attr):

    if attr[0] == '_':
      raise AttributeError, attr

    print "\n service '%s' get '%s' " % (self.__service,attr)

    method = _ProxyObject (self.__adapter, self.__service + '.' + attr, False)
    
    method.__parent = self
    print method.__parent
    self.__dict__ [attr] = method
    return method


  def __del__(self):
    
    if self.__dynamic:
    # if it is a dynamic object then close it
    #if self._attrPath==[self._attr]:
      self.__adapter.runMethod(self.__service + '._close')
