#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2002-2005 Free Software Foundation
#
# FILE:
# FileSelector.py
#
# DESCRIPTION:
#
# NOTES:
#


import os
import math

from constants import *
from Dialog import Dialog
from DirChooser import DirChooser
from FileSelectPad import FileSelectPad
from Progress import Progress
from TextBox import TextBox
from Label import Label
from Button import Button

class FileSelector(Dialog):
  """
  """
  def __init__(self, Root, Y, X, H,W,Title="", **properties):
    """
    """   
    if H == 0:
      W = int(math.floor(Root.Width() * 0.9))
      X = int(math.floor((Root.Width() - W) / 2))
      H = int(math.floor(Root.Height() * 0.6))
      Y = int(math.floor((Root.Height() - H) / 2))

    Dialog.__init__(self,Root, Y, X, Y + H, X + W,**properties)

    self.start = os.environ['PWD']
    # allow arbitrary path to be sent in as 'START'
    if self.HasProperty("START"):
      self.start = self.START
    self.W = W
    self.filePad = FileSelectPad(self,3,2,H-8,W-4)
    self.filePad.SetMethod("ACTION",self._SetPath)
    self.filePad.SetMethod("ACTIVE",self._SetFileName)
    self.progressBar = Progress(self,'filedisppb',H-3,2,W-14,1)
    self.filePad.PROGRESS = self.progressBar
    self.AddControl(self.filePad)
    self.AddControl(self.progressBar)
    self.fileNameInp = TextBox(self,'filenameinp',H-2, 2, W - 14)
    self.AddControl(self.fileNameInp)
    self.dirChooser = DirChooser(self,1,1,W-2,self.start,'choose' )
    self.dirChooser.SetMethod("CHANGED",self._newDir)
    self.dirChooser._DirChooser__Scan(self.start)
    self.AddControl(self.dirChooser)
    labelRow = chr(tiLTEE) + (W-2)*chr(tiHLINE) + chr(tiRTEE)
    self.AddControl(Label(self,'upperborder',2,0,labelRow))
    self.AddControl(Label(self,'lowerborder',H-4,0,labelRow))
    self.cancel_button = Button(self,'cancelbutt',H-2 ,W-11 , 10, 'Cancel')
    self.accept_button = Button(self,'acceptbutt',H-3 ,W-11 , 10, 'Accept')
    self.AddControl(self.accept_button)
    self.AddControl(self.cancel_button)
    self.cancel_button.SetMethod("CLICK",self.Cancel)
    self.accept_button.SetMethod("CLICK",self.Accept)

  def Show(self):
#    self.filePad.Paint(0,0,0)
    self.RunDialog()
    return self.__accept

  def Cancel(self,control,arg2,arg3):
    self.dirChooser.dir_entries = []
    self.fileNameInp.SetText('')
    control.EXITFORM = 1
    self.__accept = 0
    return 0

  def Accept(self,control,arg2,arg3):
    control.EXITFORM = 1
    self.__accept = 1
    return 1

  def GetPath(self):
    if self.dirChooser.HasEntries():
      erg = self.dirChooser.dir_entries[0]
      if erg[-1:] != '/':
        erg = erg + '/'
      return erg
    else:
      return ''

  def GetFileName(self):
    return self.fileNameInp.GetText()

  def GetFullPath(self):
    return self.GetPath() + self.GetFileName()

  def Refresh(self,arg1,arg2,arg3):
    self.filePad.Paint(None,None,None)
    apply(Dialog.Paint,(self,))

  def _SetPath(self,Control, Path, Arg3):
    if self.dirChooser.AddPath(Path,None,None) :
      self.fileNameInp.SetText("")
    
  def _SetFileName(self,Control, Name, Arg3):
    self.fileNameInp.SetText(Name)

  def _newDir(self, newpath):
    self.filePad.Display(newpath)
#
# radio button group
#


