#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2001-2004 Free Software Foundation
#
# $Id: Definition.py 5212 2004-03-03 16:47:06Z johannes $
#

# =============================================================================
# The basic definition class
# =============================================================================

class Definition:
  """
  This class implements a basic definition. Each definition has a name.
  """


  # ---------------------------------------------------------------------------
  # Constructor
  # ---------------------------------------------------------------------------

  def __init__ (self, name = None):
    self.name     = name



# =============================================================================
# TableDefinition adds postfield- and index- sequences
# =============================================================================

class TableDefinition (Definition):
  """
  A TableDefinition introduces another property fields which is a list of
  FieldDefinition objects. This table definition encapsulates only a single 
  data row. Use newRow () to initialize an instance for another data row.
  """

  # ---------------------------------------------------------------------------
  # Constructor
  # ---------------------------------------------------------------------------

  def __init__ (self, name = None):
    Definition.__init__ (self, name)

    self.rows = []


  # ---------------------------------------------------------------------------
  # Initialize instance for a new data row
  # ---------------------------------------------------------------------------

  def addRow (self):
    """
    This function clears the fields-sequence.
    """
    newRow = RowDefinition ()
    self.rows.append (newRow)
    return newRow


# =============================================================================
# Definition class for a data row
# =============================================================================

class RowDefinition (Definition):
  """
  This class encapsulates a single data row of a table
  """

  # ---------------------------------------------------------------------------
  # Constructor
  # ---------------------------------------------------------------------------

  def __init__ (self):
    Definition.__init__ (self, None)
    self.values    = []
