#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2001-2004 Free Software Foundation
#
# FILE:
# sockets/CommDriver.py
#
# DESCRIPTION:
# Class that implements a socket-based driver for GNUe Comm.
#
# NOTES:
# Unlike the other drivers, this driver implements it's own, proprietary 
# (but not unfree :) interface.  The client portion of this driver is only
# intended to connect to instances of the Server contained in this file
# (i.e., the client isn't designed to connect to, e.g., a PostgreSQL socket
# interface).   
#
# Server parameters:
#
#    socket      The filename of the file socket to create. 
#                (e.g., /tmp/gnue/MyApp.socket) 
#    host        The hostname or IP address of the service
#    port        The port that the service is located on.
#
#                Note: If both socket and host,port are specified, then
#                      both a sockets file and a TCP port are opened.
#
# Client parameters:
#
#    socket      The filename of the file socket.
#                (e.g., /tmp/gnue/MyApp.socket) 
#    ..or..
#    host        The hostname or IP address of the service
#    port        The port that the service is located on
#



#
# We provide both a client and a server driver...
#
CLIENT = 1      # ClientAdapter
SERVER = 1      # ServerAdapter

from gnue.common.rpc.drivers._helpers.AsyncSocketServer import AsyncSocketServer
from gnue.common.rpc.drivers._helpers import ObjectLibrarian

from gnue.common.rpc.drivers import GCommBase
from gnue.common.rpc import GComm

import string
import socket


#
# ClientAdapter
#
class ClientAdapter(GCommBase.Client):

  def __init__(self, params):
    try:
      file = params['socket']
      if not len(file):

        raise KeyError

      if not hasattr(socket, 'AF_UNIX'): 
        tmsg =   _("Your configuration references a file-based sockets connection.\n") \
               + _("However, your operating system does not support file-based sockets.")
        raise GComm.AdapterConfigurationError,  tmsg

      self._location = file

      try:

        self.__socket = socket.socket(socket.AF_UNIX, socket.SOCK_STREAM) 
        self.__socket.connect(file) 

      except: 
        tmsg =   _("Unable to initialize the requested socket located at %s") % \
                (file)
        raise AdapterInitializationError, tmsg

 
    except KeyError:

      try: 

        host = params['host']
        port = params['port']
        self._location = "%s:%s" % (host, port)

        self.__socket = socket.socket(socket.AF_INET, socket.SOCK_STREAM) 
        self.__socket.connect((host, port)) 

      except KeyError: 
        tmsg =  _("To use the sockets commdriver, you must specify either a sockets") \
              + _("\nfile or a host and port number.  Please see documentation.")
        raise GComm.AdapterConfigurationError, tmsg

      except: 
        tmsg = _("Unable to initialize the requested socket located at %s:%s") % \
               (host,port)
        raise AdapterInitializationError, tmsg


  def __repr__(self): 
    return "<sockets.ClientAdapter [talking with %s] at %s>" % \
        ( self._location, id(self) )


  def requestService(self, service, params={}):
    proxy = _ProxyObject(self, None, servicer=self._server.__getattr__(service))


  def close():
    pass

  def runMethod(self, method, *args, **params):
    pass

  def getAttribute(self, attribute):
    pass

  def setAttribute(self, attribute):
    pass


#
# ServerAdapter
#
class ServerAdapter(AsyncSocketServer):

  def raiseException(self, exception, message, event=None):
    pass


#
# ProxyObject
#
class _ProxyObject(GCommBase.ProxyObject):

  def __getattr__(self, attr):
    self.__dict__[attr] = _ProxyObject(self._server, self, name=attr)
    return self.__dict__[attr]

  def __repr__(self): 
    return "<sockets.ProxyObject at %s>" % (id(self))

  def __call__(self, *args, **params):
    self._server.runMethod(self, args, params)

  # Server raised an exception...
  # Translate the exception into a local python
  # exception and raise it...
  def _exceptionRaised(self, data):
    pass

