#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it 
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either 
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public 
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2004 Free Software Foundation
#
#
# FILE:
# GBinary.py
#
# DESCRIPTION:
# Provides a container object for binary data. 
#
# NOTES:
#


import base64
from gnue.common.definitions.GObjects import GObj

#
# GBinary
#
#
class GBinary(GObj):
  def __init__(self, name="GBinary", parent=None):
    GObj.__init__(self, name, parent=None)
    self.__data__ = ""
    self.format = "base64"
    self._phaseInits = [self.init]

  def init(self):

    if self.format == 'base64':
      self.__data__ = base64.decodestring(self.getChildrenAsContent())
    else:
      raise "Unsupported binary format: %s" % self.format

    self._children = []

  def set(self, data):
    self.__data__ = data

  def get(self, data):
    return data

  #
  # dumpXML
  #
  # Dumps an XML representation of the object
  # used in saving
  #
  def dumpXML(self, lookupDict, treeDump=None, gap=None,xmlnamespaces={}):

    xmlEntity = "binary"
    xmlString = "%s<%s" % (gap[:-2],xmlEntity)

    indent = len(xmlString)
    pos = indent
    for attribute in self.__dict__.keys():

      # variables beginning with _ are never saved out to file
      # they are internal to the program
      if attribute[0] == "_":
        continue

      val = self.__dict__[attribute]
      if lookupDict[xmlEntity].has_key('Attributes') and \
         lookupDict[xmlEntity]['Attributes'].has_key(attribute):
        if val != None and \
           (not lookupDict[xmlEntity]['Attributes'][attribute].has_key('Default') or \
            (lookupDict[xmlEntity]['Attributes'][attribute]['Default']) != (val)):
          typecast = lookupDict[xmlEntity]['Attributes'][attribute]['Typecast']
          if typecast == GTypecast.boolean \
             and val == 1:
            addl = ' %s=""' % (attribute)
          elif typecast == GTypecast.names:
            addl = ' %s="%s"' % \
                (attribute, string.join(val,','))
          else:
            addl = ' %s="%s"' % (attribute, saxutils.escape('%s' % val))
          if len(addl) + pos > 78:
            xmlString += "\n" + " " * indent + addl
            pos = indent
          else:
            xmlString = xmlString + addl
            pos += len(addl)

    xmlString += ">\n"
    if self.format == 'base64':
      xmlString += base64.encodestring(self.__data__)
    else:
      raise "Unsupported binary format: %s" % self.format
    xmlString += "%s</%s>\n" % (gap[:-2], xmlEntity)

    return xmlString


  def getChildrenAsContent(self):
    return self.__data__



#
# Return any XML elements associated with
# GTriggers.  Bases is a dictionary of tags
# whose values are update dictionaries.
# For example: bases={'datasource': {'BaseClass':myDataSource}}
# sets xmlElements['datasource']['BaseClass'] = myDataSource
#
def getXMLelements(updates={}):

  xmlElements = {
      'binary': {
         'BaseClass': GBinary,
         'Importable': 1,
         'Attributes': {
            'name': {
               'Unique': 1,
               'Typecast': GTypecast.name },
            'encoding': {
               'Typecast': GTypecast.uppername,
               'ValueSet': {
#                   'uuencode': {} },  # TODO
#                   'binhex': {} },    # TODO
                   'base64': {} },
               'Default': 'base64' } },
         'MixedContent': 0,
         'KeepWhitespace': 0,
         'UsableBySiblings': 1,
         'ParentTags': None },
      }

  for alteration in updates.keys():
    xmlElements[alteration].update(updates[alteration])

  return xmlElements

