#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2004 Free Software Foundation
#
# FILE:
# sybase/DBdriver.py
#
# DESCRIPTION:
# Driver to provide access to data via Dave Cole's Sybase ASE/Python Driver
# Requires Sybase.py (http://www.object-craft.com.au/projects/sybase/)
#
# NOTES:
#
#   Supported attributes (via connections.conf or <database> tag)
#
#     service=    This is the Sybase DSN for your connection  (required)
#     dbname=     This is the Sybase database to use (optional)
#

####                                   ####
#### IF YOU MODIFY ANY CONNECTION      ####
#### ATTRIBUTES, PLEASE UPDATE info.py ####
####                                   ####

__all__ = ['Connection']

from string import lower
import sys
from gnue.common.datasources import GDataObjects, GConditions, GConnections
from gnue.common.apps import GDebug
from gnue.common.datasources.drivers import DBSIG2
from DataObject import *

try:
  import Sybase as SIG2api
except ImportError:
  raise GConnections.DependencyError, ('Sybase.py', None)


class Connection(DBSIG2.Connection):

  _driver = SIG2api
  _DatabaseError = SIG2api.DatabaseError
  supportedDataObjects = {
    'object': DataObject_Object,
    'sql':    DataObject_SQL
  }

  def connect(self, connectData):
    GDebug.printMesg(1,"Sybase database driver initializing")
    try:
      if connectData.has_key('dbname'):
        self.native = SIG2api.connect( \
                  service=connectData['service'],  \
                  user=connectData['_username'], \
                  passwd=connectData['_password'], \
                  datbase=connectData['dbname'])
      else:
        self.native = SIG2api.connect( \
                  service=connectData['service'],  \
                  user=connectData['_username'], \
                  passwd=connectData['_password'])
    except self._DatabaseError, value:
      raise GDataObjects.LoginError, value

