#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2004 Free Software Foundation
#
# FILE:
# SQLitedb/DBdriver.py
#
# DESCRIPTION:
# Driver to provide access to data via SQLite's Python Driver.
# Requires PySQLite (http://pysqlite.sf.net/)
#
# NOTES:
#
#   Supported attributes (via connections.conf or <database> tag)
#
#     dbname=    This is the SQLite database to use (required)
#

__all__ = ['Connection']

####                                   ####
#### IF YOU MODIFY ANY CONNECTION      ####
#### ATTRIBUTES, PLEASE UPDATE info.py ####
####                                   ####

from string import lower,find,rfind,split,strip
import sys
from gnue.common.datasources import GDataObjects, GConditions, GConnections
from gnue.common.apps import GDebug
from gnue.common.datasources.drivers import DBSIG2

try:
  import sqlite as SIG2api
except ImportError:
  raise GConnections.DependencyError, ('SQLitedbapi', None)

from gnue.common.datasources.drivers.sqlite.Schema.Discovery.Introspection import Introspection


######################################################################
#
#  GConnection object for PostgreSQL-based drivers
#
class Connection(DBSIG2.Connection):

  _driver = SIG2api
  _DatabaseError = SIG2api.DatabaseError
  defaultBehavior = Introspection
  supportedDataObjects = {
    'object': DataObject_Object,
    'sql':    DataObject_SQL
  }

  def connect(self, connectData={}):
    GDebug.printMesg(1,"SQLite database driver initializing")
    try:
      self.native = SIG2api.connect(  \
                   db=connectData['dbname'], \
                   mode=077 )
    except self._DatabaseError, value:
      raise GDataObjects.LoginError, value


  # Return a list of necessary login fields (e.g., user/pass).
  # Each list item is another list of ["field label", isPassword?]
  def getLoginFields(self):
    return []
