#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or(at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2004 Free Software Foundation
#
# FILE:
# Introspection.py
#
# DESCRIPTION:
#
# NOTES:
#

__all__ = ['Introspection']

import string
from string import lower, join, split
import sys

from gnue.common.apps import GDebug, GConfig
from gnue.common.apps import GDebug, GConfig
from gnue.common.datasources import GIntrospection

class Introspection(GIntrospection.Introspection):

  # list of the types of Schema objects this driver provides
  types =[ ('table',    _('Tables'),1),
           ('view',     _('Views'), 1),
           ('synonym',  _('Synonyms'),1),
           ('result',   _('Result Table'),1) ]

  #
  # TODO: This is a quick hack to get this class
  # TODO: into the new-style schema format.
  # TODO: getSchema* should be merged into find()
  #
  def find(self, name=None, type=None):
    if name is None:
      return self.getSchemaList(type)
    else:
      rs = self.getSchemaByName(name, type)
      if rs:
        return [rs]
      else:
        return None


  # TODO: Merge into find()
  # Return a list of Schema objects

  # Return a list of Schema objects
  def getSchemaList(self, type=None):

    where_user = ""
    if type == None:
      where_type = "where TYPE <> 'SYSTEM' and TYPE <> 'SYNONYM' "
    else:
      where_type = "where TYPE='%s'" % string.upper(type)


    statement = \
      "select owner||'.'||tablename||'.'||type, " + \
        "owner||'.'||tablename table_name, " + \
        "type table_type " + \
        "from domain.tables %s" \
              % (where_type) + \
          "order by tablename "

    GDebug.printMesg(5,statement)

    cursor = self._connection.native.cursor()
    cursor.execute(statement)

    list = []
    for rs in cursor.fetchall():
      list.append(GIntrospection.Schema(attrs={'id':rs[0], 'name':rs[1],
                         'type':string.lower(rs[2])},
                         getChildSchema=self.__getFieldSchema))

    cursor.close()
    return list


  # Find a schema object with specified name
  def getSchemaByName(self, name, type=None):

    where_user = ""
    parts = string.split(string.upper(name),'.')
    name = parts[-1]
    if len(parts) > 1:
      schema = " and owner='%s'" % parts[-2]
    else:
      schema = ""

    statement = \
      "select owner||'.'||tablename||'.'||type, " + \
        "owner||'.'||tablename table_name, " + \
        "type table_type, " + \
        "owner, tablename " + \
        "from domain.tables where tablename='%s'%s" \
              % (name, schema) + \
          "order by tablename "

    GDebug.printMesg(5,statement)

    cursor = self._connection.native.cursor()
    cursor.execute(statement)

    list = []
    for rs in cursor.fetchall():
      list.append(GIntrospection.Schema(attrs={'id':string.lower(rs[0]), 'name':rs[1],
                         'type':rs[2], 'sapdbId': (rs [3], rs [4])},
                         getChildSchema=self.__getFieldSchema))

    cursor.close()

    try:
      return list[0]
    except:
      return None



  # Get fields for a table
  def __getFieldSchema(self, parent):

    # TODO: This does not support user-defined datatypes...
    # TODO: it will always report such as TEXT-like fields.

    schema, name, type = string.split(parent.id,'.')
    owner, basename = parent.sapdbId
    cursor = self._connection.native.cursor()

#    if type == 'synonym':
#      statement = "select base_tabschema, base_tabname " + \
#                  "from syscat.tables " + \
#                  "where tabschema = '%s' and tabname='%s'" % (schema, name)
#
#      GDebug.printMesg(5,statement)
#
#      cursor.execute(statement)
#      rs = cursor.fetchone()
#      schema, name = rs

    statement = \
       "select owner||'.'||tablename||'.'||columnname, " + \
       "columnname, datatype, 'Y', len, dec " + \
       "from domain.columns " + \
       "where owner = '%s' and tablename = '%s' " % (owner, basename) + \
       'order by "POS"'

    GDebug.printMesg(5,statement)

    cursor.execute(statement)

    list = []
    for rs in cursor.fetchall():

      attrs={'id': rs[0], 'name': rs[1],
             'type':'field', 'nativetype': rs[2],
             'required': 'N'}

      if rs[2] in ('BOOLEAN','FIXED','FLOAT','INTEGER','LONG','SMALLINT'):
        attrs['precision'] = rs[5]
        attrs['datatype'] = 'number'
      elif rs[2] in ('DATE','TIME','TIMESTAMP'):
        attrs['datatype'] = 'date'
      else:
        attrs['datatype'] = 'text'

      if rs[5] != 0:
        attrs['length'] = rs[4]

      list.append(GIntrospection.Schema(attrs=attrs))

    cursor.close()
    return tuple(list)

