#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2004 Free Software Foundation
#
# FILE:
# Oracle/Base/DataObject.py
#
# DESCRIPTION:
#
# NOTES:
#
#   Supported attributes (via connections.conf or <database> tag)
#
#     service=    This is the Oracle TNS name for your connection  (required)
#

__all__ = ['DataObject_SQL','DataObject_Object']


from gnue.common.datasources.drivers import DBSIG2

class _Base:
  _escapeSingleQuote = '\'\''
  _dateTimeFormat = "'%Y-%m-%d %H:%M:%S'"
  _primaryIdChecked = 0

  def _checkForPrimaryId(self):

    self._primaryIdChecked = 1

    try:
      statement =  "select rowidtochar(rowid) from %s where 1=2" % self.table
      cursor = self._connection.cursor()
      cursor.execute(statement)
      cursor.close()

      self._primaryIdSelect = "ROWIDTOCHAR(ROWID) as GNUE__ROWID__"
      self._primaryIdField = "gnue__rowid__"  # Keep this lowercase!!!
      self._primaryIdFormat = "ROWID = CHARTOROWID('%s')"
      GDebug.printMesg(5,'View %s is using ROWID identifier' % self.table)

    except self._DatabaseError:
      GDebug.printMesg (5, 'View %s has no internal ROWID' % self.table)

class DataObject_SQL(_Base, DBSIG2.DataObject_SQL):
  pass

class DataObject_Object(_Base, DBSIG2.DataObject_Object):
  pass
