#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or(at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2004 Free Software Foundation
#
# FILE:
# Introspection.py
#
# DESCRIPTION:
#
# NOTES:
#

__all__ = ['Introspection']

import string
from string import lower, join, split
import sys

from gnue.common.apps import GDebug, GConfig
from gnue.common.apps import GDebug, GConfig
from gnue.common.datasources import GIntrospection

class Introspection(GIntrospection.Introspection):

  # list of the types of Schema objects this driver provides
  types =[ ('table',_('Tables'),1) ]

  #
  # TODO: This is a quick hack to get this class
  # TODO: into the new-style schema format.
  # TODO: getSchema* should be merged into find()
  #
  def find(self, name=None, type=None):
    if name is None:
      return self.getSchemaList(type)
    else:
      rs = self.getSchemaByName(name, type)
      if rs:
        return [rs]
      else:
        return None


  # TODO: Merge into find()
  # Return a list of Schema objects

  #
  # Schema (metadata) functions
  #

  # Return a list of Schema objects
  def getSchemaList(self, type=None):

    # TODO: This excludes any system tables and views. Should it?
    statement = "SHOW TABLES"

    cursor = self._connection.native.cursor()
    cursor.execute(statement)

    list = []
    for rs in cursor.fetchall():
      list.append(GIntrospection.Schema(attrs={'id':rs[0], 'name':rs[0],
                         'type':'table',
                         'primarykey': self.__getPrimaryKey(rs[0])},
                         getChildSchema=self.__getFieldSchema))

    cursor.close()
    return list


  # Find a schema object with specified name
  def getSchemaByName(self, name, type=None):
    statement = "DESCRIBE %s" % (name)

    cursor = self._connection.native.cursor()
    cursor.execute(statement)

    rs = cursor.fetchone()
    if rs:
      schema = GIntrospection.Schema(attrs={'id':name, 'name':name,
                           'type':'table',
                           'primarykey': self.__getPrimaryKey(name,cursor)},
                           getChildSchema=self.__getFieldSchema)
    else:
      schema = None

    cursor.close()
    return schema


  def __getPrimaryKey(self, id, cursor=None):
    statement = "DESCRIBE %s" % id
    if not cursor:
      cursor = self._connection.native.cursor()
      close_cursor = 1
    else:
      close_cursor = 0
    cursor.execute(statement)

    lst = []
    for rs in cursor.fetchall():
      if rs[3] == 'PRI':
        lst.append(rs[0])

    if close_cursor:
      cursor.close()

    return tuple(lst)

  # Get fields for a table
  def __getFieldSchema(self, parent):

    statement = "DESCRIBE %s" % parent.id

    cursor = self._connection.native.cursor()
    cursor.execute(statement)

    list = []
    for rs in cursor.fetchall():

      nativetype = string.split(string.replace(rs[1],')',''),'(')


      attrs={'id': "%s.%s" % (parent.id, rs[0]), 'name': rs[0],
             'type':'field', 'nativetype': nativetype[0],
             'required': rs[2] != 'YES'}

      if nativetype[0] in ('int','integer','bigint','mediumint',
                           'smallint','tinyint','float','real',
                           'double','decimal'):
        attrs['datatype']='number'
      elif nativetype[0] in ('date','time','timestamp','datetime'):
        attrs['datatype']='date'
      else:
        attrs['datatype']='text'

      try:
        if len(nativetype) == 2:
          try:
            ln, prec = nativetype[1].split(',')
          except:
            ln = nativetype[1]
            prec = None
          attrs['length'] = int(ln.split()[0])
          if prec != None:
            attrs['precision'] = int(prec)
      except ValueError:
        GDebug.printMesg(1,'WARNING: mysql native type error: %s' % nativetype)

      if rs[4] not in ('NULL', '0000-00-00 00:00:00','', None):
        attrs['defaulttype'] = 'constant'
        attrs['defaultval'] = rs[4]

      if rs[5] == 'auto_increment':
        attrs['defaulttype'] = 'serial'


      list.append(GIntrospection.Schema(attrs=attrs))

    cursor.close()
    return list

