#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2004 Free Software Foundation
#
# FILE:
# gadfly/DBdriver.py
#
# DESCRIPTION:
"""
Driver to provide access to data via Gadfly
"""
# NOTES:
# The Gadfly notes state that it is not safe to use in a multi-user environment
# where there may be concurrent read/writes. Use at own risk :)

__all__ = ['Connection']

####                                   ####
#### IF YOU MODIFY ANY CONNECTION      ####
#### ATTRIBUTES, PLEASE UPDATE info.py ####
####                                   ####

import string
import sys
from gnue.common.apps import GDebug
from gnue.common.datasources import GDataObjects, GConnections
from gnue.common.datasources.drivers import DBSIG2

try:
  import gadfly
except ImportError:
  raise GConnections.DependencyError, ('gadfly', None)


##### EVIL HACK
class Error(StandardError):
  """Generic Error"""

class InterfaceError(Error):
  """Interface Error"""

class DatabaseError(InterfaceError):
  """DB Error"""

class DataError(DatabaseError):
  """Data Error"""

class OperationalError(DatabaseError):
  """Operational Error"""

class IntegrityError(DatabaseError):
  """Integrity Error"""

##### END EVIL HACK

class Connection(DBSIG2.Connection):

  _driver = gadfly
  _DatabaseError = Error
  supportedDataObjects = {
   'object': DataObject_Object,
   'sql':    DataObject_SQL
  }

  def connect(self, connectData={}):
    GDebug.printMesg(1,"Gadfly database driver initializing")
    #GDebug.printMesg(1,"Connecting with %s, %s" %( connectData['_dbname'], connectData['directory']))
    try:
      self.native = gadfly.gadfly(connectData['dbname'],
                                           connectData['directory'])
    except self._DatabaseError, value:
      #GDebug.printMesg(1,"Boom")
      raise GDataObjects.LoginError, value

    self._beginTransaction()


  def _beginTransaction(self):
    try:
      self.native.begin()
    except:
      pass

  # This should be over-ridden only if driver needs more than user/pass
  def getLoginFields(self):
    return []


  #
  # Extensions
  #

  # Return the current date, according to database
#  def getDate(self):
#    pass

  # Return a sequence number from sequence 'name'
#  def getSequence(self, name):
#    pass

