#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2001-2004 Free Software Foundation
#
# FILE:
# dbf/DBdriver.py
#
# DESCRIPTION:
# Virtual database driver for loading data from a DBF file
#
# NOTES:
# Used whenever a data has to be imported from dbase III+
#

__all__ = ['DataObject']

from gnue.common.apps import GDebug
import string
from gnue.common.datasources.GDataObjects import *
from gnue.common.drivers.special.static.Driver import *
import dbf


###########################################################
#
# This is an static data driver for connectionless clients
#
###########################################################
class DataObject (StaticDataObject): 

  def __init__(self):
    DataObject.__init__(self)
    self.triggerExtensions = TriggerExtensions(self)
    self._DatabaseError = Error
  
  def _createResultSet(self, conditions={}, readOnly=0, masterRecordSet=None, sql=""):
    return DBF_ResultSet(self, masterRecordSet=masterRecordSet)


  #
  # Schema (metadata) functions
  #

  # Return a list of the types of Schema objects this driver provides
  def getSchemaTypes(self):
    return [('table',_('Tables'),1)]




###########################################################
#
#
#
###########################################################
class DBF_ResultSet(STATIC_ResultSet):

  def __init__(self, dataObject, cursor=None, defaultValues={}, masterRecordSet=None):
    ResultSet.__init__(self, dataObject, \
            cursor, defaultValues, masterRecordSet)

    self._recordSetClass = STATIC_RecordSet

  # Returns 1=DataObject has uncommitted changes
  def isPending(self):
    return 0    # Static DataObjects cannot have pending changes :)

  # Post changes to the database
  def post(self):
    # Leave this here in case (for some bizarro reason)
    # a bound dataobject uses us as a master
    for record in (self._cachedRecords):
      record.post()

  # Load cacheCount number of new records
  def _loadNextRecord(self):
    if hasattr(self,"_alldataloaded"):
      return 0
    
    # Load static data
    for row in self._dataObject._dataConnection:
      dict = {}
      c=0
      for f in self._dataObject._dataConnection.fields:
        dict[string.lower(f[0])] = row[c]
        c+=1

      record=self._recordSetClass(parent=self,initialData=dict)
      
      self._cachedRecords.append (record)
      
      self._recordCount=self._recordCount+1

    self._alldataloaded = 1
      
    return 1



######################################
#
#  The following hashes describe
#  this driver's characteristings.
#
######################################

#
#  All datasouce "types" and corresponding DataObject class
#
supportedDataObjects = {
  'static': DBF_DataObject,
  'object': DBF_DataObject
}


