# GNU Enterprise Datasource Library - Driver for GNUe-AppServer
#
# Copyright 2000-2004 Free Software Foundation
#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# $Id: Connection.py 5640 2004-04-05 13:18:30Z reinhard $

####                                   ####
#### IF YOU MODIFY ANY CONNECTION      ####
#### ATTRIBUTES, PLEASE UPDATE info.py ####
####                                   ####

import sys

from gnue.common.datasources import Exceptions
from gnue.common.datasources.drivers import Base
from gnue.common.rpc import client

import DataObject

from gnue.common.datasources.drivers.appserver.Schema.Discovery.Introspection import Introspection

# =============================================================================
# Connection class
# =============================================================================

class Connection (Base.Connection):
  """
  Handles a connection to the GNUe-AppServer backend.
  """
  defaultBehavior = Introspection
  supportedDataObjects = {
    'object': DataObject.DataObject
  }

  # ---------------------------------------------------------------------------
  # Define the needed information to log in
  # ---------------------------------------------------------------------------

  def getLoginFields (self):
    return [['_username', 'User Name', 0], ['_password', 'Password', 1]]

  # ---------------------------------------------------------------------------
  # Open a connection
  # ---------------------------------------------------------------------------

  def connect (self, connectData):

    user = connectData ['_username']
    passwd = connectData ['_password']

    params = {'host': connectData ['host'],
              'port': connectData ['port'],
              'transport': connectData ['transport']}

    self._server = client.attach (connectData ['rpctype'], params)

    if connectData.has_key ('timeout'):
      self._server.setTimeout (float (connectData ['timeout']))

    self._sm = self._server.request ('Session')

    try:
      self._sess_id = self._sm.open ({'user': user, 'password': passwd})
    except client.DistantError, e:
      if e.type == 'AuthError':
        raise Exceptions.LoginError, e.message
      else:
        raise Exceptions.ConnectionError, e.message
    except gException, e:
      raise Exceptions.ConnectError, e.message  # handle unicode message
    except:
      raise Exceptions.ConnectError, str (sys.exc_info () [1])

    # Can be removed after the call to _dataConnection.cursor() is removed from
    # the Base driver
    self.native = self

  # ---------------------------------------------------------------------------
  # Commit active transaction
  # ---------------------------------------------------------------------------

  def commit (self):
    self._sm.commit (self._sess_id)

  # ---------------------------------------------------------------------------
  # Rollback active transaction
  # ---------------------------------------------------------------------------

  def rollback (self):
    self._sm.rollback (self._sess_id)

  # ---------------------------------------------------------------------------
  # Close connection
  # ---------------------------------------------------------------------------

  def close (self):
    self._sm.close (self._sess_id, False)

  # Can be removed after the call to _dataConnection.cursor() is removed from
  # the Base driver
  def cursor(self):
    return None
