#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2004 Free Software Foundation
#
# FILE:
# adodbapi/DataObject.py
#
# DESCRIPTION:
# Driver to provide access to data via adodbapi Driver
#
# NOTES:
#

__all__ = ['DataObject_SQL','DataObject_Object']

from gnue.common.datasources import GDataObjects, GConditions, GConnections
from gnue.common.apps import GDebug
from gnue.common.datasources.drivers import DBSIG2



class DataObject_Object(DBSIG2.DataObject_Object):

  def _createResultSet(self, conditions={}, readOnly=0, masterRecordSet=None,sql=""):

    # Used by drivers with a unique id (like rowid)
    if not self._primaryIdChecked: self._checkForPrimaryId()

    try:
      cursor = self._dataConnection.cursor()

      cursor.arraysize = self.cache
      cursor.execute(self._buildQuery(conditions, additionalSQL=sql))

      # pull a record count
      if self._strictQueryCount:
#        #disable the count query and see if anyone screams
#        recordCount = cursor.rowcount

        #adodbapi screams :(
        recordCount = self._getQueryCount(conditions,sql)

    except self._DatabaseError, err:
      raise GDataObjects.ConnectionError, err

    rs = self._resultSetClass(self, cursor=cursor, masterRecordSet=masterRecordSet)
    if self._strictQueryCount:
      rs._recordCount = recordCount
    if readOnly:
      rs._readonly = readOnly

    return rs

DataObject_SQL = DBSIG2.DataObject_SQL
