#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2004 Free Software Foundation
#
# FILE:
# adodbapi/Connection.py
#
# DESCRIPTION:
# Driver to provide access to data via adodbapi Driver
#
# NOTES:
#

__all__ = ['Connection']

####                                   ####
#### IF YOU MODIFY ANY CONNECTION      ####
#### ATTRIBUTES, PLEASE UPDATE info.py ####
####                                   ####

from gnue.common.datasources import GDataObjects, GConditions, GConnections
from gnue.common.apps import GDebug
from gnue.common.datasources.drivers import DBSIG2
from DataObject import *

try:
  import adodbapi as SIG2api
except ImportError:
  raise GConnections.DependencyError, ('adodbapi', None)

try:
  import win32com
except ImportError:
  raise GConnections.DependencyError, ('win32com', None)

from gnue.common.datasources.drivers.adodbapi.Schema.Discovery.Introspection import Introspection

class Connection(DBSIG2.Connection):
  defaultBehavior = Introspection
  _driver = SIG2api
  _DatabaseError = SIG2api.DatabaseError
  supportedDataObjects = {
    'object': DataObject_Object,
    'sql':    DataObject_SQL
  }

  def connect(self, connectData={}):
    GDebug.printMesg(1,"Adodbapi database driver initializing")

    try:
      connPar = {'Provider': connectData['oledb_provider'],
                      'Data Source' : connectData['data_source'],
                      'User Id' : connectData['_username'],
                      'Password' : connectData['_password']
                     }
      # optional parameters for MS SQL Server
      for gnueName, oledbName in [('initial_catalog', 'Initial Catalog'),
                                              ('network_library', 'Network Library'),
                                              ('data_provider', 'Data Provider'),
                                              ]:
          if connectData.has_key(gnueName):
              connPar[oledbName] = connectData[gnueName]

      connStr = ';'.join([r"%s=%s" % (k,v) for k,v in connPar.items()])
      GDebug.printMesg(1,'Adodbapi connection string="%s"' % connStr)

      self.native = SIG2api.connect(connStr)

    except self._DatabaseError, value:
      raise GDataObjects.LoginError, value

