#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2004 Free Software Foundation
#
# FILE:
# Connection.py
#
# DESCRIPTION:
#
# NOTES:
#

__all__ = ['Connection']


# System Init:
#   +-- GConnections initializes
#   +-- GParser initializes:
#     +-- GDataSource loaded
#   +-- GDataSources Intialized
#     +-- GConnection.getDataObject()
#       +--
#
class Connection:
  def __init__(self, connections, name, parameters):
    self.manager = connections
    self.parameters = parameters
    self.name = name

    # Text encoding used by the database.
    # (Not all databases support this concept)
    try:
      self._encoding = parameters['encoding']
    except KeyError:
      try:
         self._encoding = gConfig('textEncoding')
      except:
        # TODO: Is this a safe default?
        self._encoding = 'iso8859-1'


  # Commit changes to the database
  def commit(self):
    pass

  # Rollback changes to the database
  def rollback(self):
    pass

  # Close the connection to the database backend
  def close(self):
    pass

  def connect(self, connectData):
    pass
