#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2002-2004 Free Software Foundation
#
# FILE:
# Button.py
#
# DESCRIPTION:
#
# NOTES:
#


from constants import *
from Control import Control
import curses
import sio

#
#  An example control implementation doing a command button
#
class Button(Control):
  def __init__(self, Parent, ButtonName, Y, X, W, Caption, **properties):
    Control.__init__(self, Parent, ButtonName, **properties)
    self.PARENT = Parent
    self.X = X
    self.Y = Y
    self.CLASS = "BUTTON"
    self.W = W
    self.H = 1
    self.FOCUS = 0
    self.CANGETFOCUS = 1
    self.CAPTION = Caption #
    self.SetMethod("SYSGOTFOCUS", self.GotFocus) # system event
    self.SetMethod("SYSLOSTFOCUS", self.LostFocus) # system event
    self.SetMethod("SYSPAINT", self.Paint) # system event
    self.SetMethod("CLICK", None)   # user event
    self.SetMethod("LOSTFOCUS", None)   # user event
    self.SetMethod("GOTFOCUS", None)  # user event
    self.SetMethod("SYSRUN", self.Run)  # system event
    self.EXITFORM = 0
    self.SetColor('BUTTON','BUTTON_FOCUS')


  def Run(self, v1, v2, v3):    # handle user actions
    Container = self.PARENT.SCREEN
    if v1 :
      self.ExecMethod("CLICK", self, None, None)
      if self.EXITFORM:
        return 1
      self.ExecMethod("SYSGOTFOCUS", None, None, None)
    global BACKWARDS
    while 1:
      ch = Container.GetChar()
      if self.PARENT.BreakOrder(ch) :
        return

      ch = self.PARENT.KeystrokeHook(ch)
      if ch == None:
        return

      if self.active == 0:
        return 0
      if ch in (Container.TokNextField, Container.TokRightArrow):
        BACKWARDS = 0
        return 0
      elif ch == Container.TokLeftArrow:
        BACKWARDS=1
        return 0
      elif ch in (self.PARENT.SCREEN.TokActivate, 32):
        self.ExecMethod("CLICK", self, None, None)
        if self.EXITFORM:
          return(1)
        self.ExecMethod("SYSGOTFOCUS", None, None, None)

  def Paint(self, HaveFocus, v2, v3):           # event args not used
    """
      control's paint event
      There are two ways to tell if we have focus or not. HaveFocus will == 1 when
      the user is sitting on the control **OR** the property FOCUS will .
      But, as you see, this is controlled by the person creating the control.
    """
    Container = self.PARENT.SCREEN
    if Container == None:
      raise "No container!"
    if HaveFocus:
      color = self.FOCUSCOLOR
    else:
      color = self.COLOR
    tROW, tCOL = self._ABSY, self._ABSX
    tCaption = self.CAPTION
    tW = self.W
    tAW = tW - 2
    if len(tCaption) > tAW:
      tCaption = tCaption[: tAW]
    elif len(tCaption) < tAW:    # spaces-stuff: text in the middle
      spaces = tAW - len(tCaption)
      if spaces % 2 == 1:
        spaces += 1
      leadingSpaces =  spaces / 2
      spaces = leadingSpaces
      if spaces + leadingSpaces + len(tCaption) > tAW:
        leadingSpaces -= 1
      elif spaces + leadingSpaces + len(tCaption) < tAW:
        spaces += 1

      tCaption = (" " * leadingSpaces) + tCaption + (" " * spaces)
    Container.PrintAt(tROW, tCOL, "<" + tCaption + ">", color)

  def GotFocus(self, Arg1, Arg2, Arg3):
    self.FOCUS = 1
    self.ExecMethod("SYSPAINT", 1, 0, 0)
    return 1

  def LostFocus(self, Arg1, Arg2, Arg3):
    self.FOCUS = 0
    self.ExecMethod("SYSPAINT", 0, 0, 0)
    return 1


