
#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2005 Free Software Foundation
#
# FILE:
# interbase/DBdriver.py
#
# DESCRIPTION:
# Driver to provide access to data via the Kinterbasdb Interbase/Firebird Python Driver
# Requires Kinterbasdb > 3.0 (http://kinterbasdb.sourceforge.net/)
#
# NOTES:

__all__ = ['DataObject_SQL','DataObject_Object']


import sys
from gnue.common.datasources import Exceptions
from gnue.common.apps import errors
from gnue.common.datasources.drivers import DBSIG2
from ResultSet import ResultSet

class _Base (DBSIG2.DataObject):
  # The date/time format used in insert/select statements
  # (based on format used for time.strftime())
  _dateTimeFormat = "cast('%Y-%m-%d %H:%M:%S' as timestamp)"
  _resultSetClass = ResultSet

  # ---------------------------------------------------------------------------
  # Create a result set
  # ---------------------------------------------------------------------------

  def _createResultSet (self, conditions = {}, readOnly = 0,
                        masterRecordSet = None, sql = ""):

    # Used by drivers with a unique id (like rowid)
    if not self._primaryIdChecked:
      self._checkForPrimaryId()

    try:
      query = self._buildQuery (conditions, additionalSQL = sql)
      cursor = self._connection.makecursor (query)
      cursor.arraysize = self.cache

    except self._DatabaseError:
      raise Exceptions.ConnectionError, errors.getException () [2]

    # Our ResultSet class performs an implicit record-count in it's constructor
    # so we won't force another duplicate count

    rs = self._resultSetClass (self, cursor = cursor,
        masterRecordSet = masterRecordSet, conditions = conditions, sql = sql,
        fieldOrder = self._fieldOrder)

    if readOnly:
      rs._readonly = readOnly

    return rs


class DataObject_Object (_Base, DBSIG2.DataObject_Object):
  pass

class DataObject_SQL (_Base, DBSIG2.DataObject_SQL):
  pass
