# GNU Enterprise Application Server - Language interface: Object
#
# Copyright 2003-2005 Free Software Foundation
#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it 
# and/or modify it under the terms of the GNU General Public 
# License as published by the Free Software Foundation; either 
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be 
# useful, but WITHOUT ANY WARRANTY; without even the implied 
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public 
# License along with program; see the file COPYING. If not, 
# write to the Free Software Foundation, Inc., 59 Temple Place 
# - Suite 330, Boston, MA 02111-1307, USA.
#
# $Id: Procedure.py 7104 2005-03-07 16:49:25Z johannes $

# =============================================================================
# Implement a callable environment for the language interface 
# =============================================================================
class Procedure:

  # ---------------------------------------------------------------------------
  # Constructor
  # ---------------------------------------------------------------------------
  def __init__ (self, session, objectId, className, procedureName):
    self.method     = session.qualify (procedureName)

    self.__session  = session
    self.__objectId = objectId
    self.__class    = className

  # ---------------------------------------------------------------------------
  # Delegate calls of this object to the session manager
  # ---------------------------------------------------------------------------
  def __call__ (self, **params):
    gEnter (6)

    sm  = self.__session.getSessionManager ()
    sid = self.__session.getSessionId ()

    result = sm.call (sid, self.__class, [self.__objectId], self.method,
                    params) [0]
    return gLeave (6, result)
