# GNU Enterprise Application Server - Test Program
#
# Copyright 2001-2005 Free Software Foundation
#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# $Id: test.py 6851 2005-01-03 20:59:28Z jcater $

import os
from gnue.common.apps.GClientApp import GClientApp
from gnue.common.datasources.GLoginHandler import LoginHandler
from gnue.appserver.geasSessionManager import geasSessionManager

# =============================================================================
# Test application
# =============================================================================

class testApp (GClientApp):

  # ---------------------------------------------------------------------------
  # Constructor
  # ---------------------------------------------------------------------------
  def __init__ (self, connections = None):
    ConfigOptions = {}
    GClientApp.__init__ (self, connections, 'appserver', ConfigOptions)


  # ---------------------------------------------------------------------------
  # Create a session manager object
  # ---------------------------------------------------------------------------
  def getSessionManager (self):
    self.connections.setLoginHandler (testLoginHandler ())

    print "Creating session manager ..."
    sm = geasSessionManager (self.connections)

    return sm


  # ---------------------------------------------------------------------------
  # Main program
  # ---------------------------------------------------------------------------
  def run (self):
    sm = self.getSessionManager ()

    print "Opening session ...",
    session = sm.open ({"user":"hacker", "password":"secret"})
    print "Ok"

    print "Creating and populating list object ...",
    list = sm.request (session, "address_person", [], ["address_zip"],
                       ["address_name", "address_street", "address_city",
                        "address_country.address_code",
                        "address_country.address_name"])
    print "Ok"

    print "Retrieving first instance ...",
    rset = sm.fetch (session,list,0,1)
    first_id = rset[0][0]
    print "Ok"

    print "These are the values of the first instance:"
    print "  Name   :", rset[0][1]
    print "  Street :", rset[0][2]
    print "  City   :", rset[0][3]
    print "  Country:", rset[0][4] + '/' + rset[0][5]

    print "Retrieving second instance ...",
    rset = sm.fetch (session,list,1,1)
    print "Ok"

    print "These are the values of the second instance:"
    print "  Name   :", rset[0][1]
    print "  Street :", rset[0][2]
    print "  City   :", rset[0][3]
    print "  Country:", rset[0][4] + '/' + rset[0][5]

    print "Executing rollback to clear cache ...",
    sm.rollback (session)
    print "Ok"

    print "Loading the first instance with load () ...",
    rset = sm.load (session, "address_person", [first_id],
                    ["address_name", "address_street", "address_city",
                     "address_country.address_code",
                     "address_country.address_name"])
    print "Ok"

    print "These are again the values of the first instance:"
    print "  Name   :", rset[0][0]
    print "  Street :", rset[0][1]
    print "  City   :", rset[0][2]
    print "  Country:", rset[0][3] + '/' + rset[0][4]

    print "Now I call the procedure 'show' for the first instance:"
    sm.call (session, "address_person", [first_id], "address_show", {})

    print "Now I call the procedure 'test' for the first instance:"
    sm.call (session, "address_person", [first_id], "address_test", {})

    print "Committing and closing session ...",
    sm.close (session, 1)
    print "Ok"


# =============================================================================
# Login Handler
# =============================================================================
class testLoginHandler (LoginHandler):
  def getLogin (self, *arguments):
    return {"_username": "gnue", "_password": None}


# =============================================================================
# Let it rock
# =============================================================================
if __name__ == "__main__":
  testApp().run()
  print "Thank you for playing!"
