# GNU Enterprise Application Server - Testing unit 
#
# Copyright 2003-2005 Free Software Foundation
#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it 
# and/or modify it under the terms of the GNU General Public 
# License as published by the Free Software Foundation; either 
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be 
# useful, but WITHOUT ANY WARRANTY; without even the implied 
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public 
# License along with program; see the file COPYING. If not, 
# write to the Free Software Foundation, Inc., 59 Temple Place 
# - Suite 330, Boston, MA 02111-1307, USA.
#
# $Id: test.py 6851 2005-01-03 20:59:28Z jcater $
#

from gnue.appserver.language import App

if __name__ == "__main__":
  app = App.App ()

  print "requesting new session ..."
  session = app.newSession ('test', 'test')

  print "fetching all persons..."
  session.setcontext ('address')

  print "running the find ..."
  persons = session.find ('person', sortorder = ['address_name'],
                       properties = ['address_name', 'address_street'])

  if persons:
    print "has a match!"

  print 'Found %d instances.' % len (persons)

  for person in persons:
    print '-' * 79
    print 'Name   : %s' % repr (person.name)
    print 'Street : %s' % repr (person.address_street)
    print 'City   : %s' % repr (person.address_city)

    if person.address_country is not None:
      print 'Country: %s' % repr (person.address_country.address_name)

    print 'Number of Children: %s' % repr (person.address_children)
    print 'Weight: %s' % repr (person.address_weight)
    print 'Born  : %s' % repr (person.address_born)
    print 'Human : %s' % repr (person.address_human)

