# GNU Enterprise Application Server - Language interface application
#
# Copyright 2003-2005 Free Software Foundation
#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it 
# and/or modify it under the terms of the GNU General Public 
# License as published by the Free Software Foundation; either 
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be 
# useful, but WITHOUT ANY WARRANTY; without even the implied 
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public 
# License along with program; see the file COPYING. If not, 
# write to the Free Software Foundation, Inc., 59 Temple Place 
# - Suite 330, Boston, MA 02111-1307, USA.
#
# $Id: App.py 6851 2005-01-03 20:59:28Z jcater $

from gnue.common.rpc import client
from gnue.common.apps import GClientApp

import Session

# =============================================================================
# Helper class for standalone applications using the Language Interface
# =============================================================================

class App (GClientApp.GClientApp):

  # ---------------------------------------------------------------------------
  # Constructor
  # ---------------------------------------------------------------------------

  def __init__ (self, connections = None, application = 'appserver',
      defaults = None):

    self.addCommandOption ('connection', 'c', argument='name',
        default = "gnue",
        help = _("Connect to the appserver using the connection <name>"))

    GClientApp.GClientApp.__init__ (self, connections, application, defaults)

    self._sm = self.__getSessionManager ()


  # ---------------------------------------------------------------------------
  # Create a new language interface session (LoginSession)
  # ---------------------------------------------------------------------------

  def newSession (self, username, password):

    return Session.LoginSession (self._sm, username, password)


  # ---------------------------------------------------------------------------
  # Create a new connection to the application server's session manager
  # ---------------------------------------------------------------------------

  def __getSessionManager (self):
    """
    This function uses the parameters specified by the given connection and
    connects to the appserver's session manager via rpc.

    @return: Session Manager
    """

    connection = self.connections.getConnection (self.OPTIONS ['connection'])
    cparams    = connection.parameters

    rpctype = cparams.get ('rpctype', 'xmlrpc')
    params  = {'host'     : cparams.get ('host', 'localhost'),
               'port'     : cparams.get ('port', 8765),
               'transport': cparams.get ('transport', 'http')}

    server = client.attach (rpctype, params)
    return server.request ('Session')
