#!/usr/bin/env python
#
# GNU Enterprise Application Server - Installation Procedure
#
# Copyright 2001-2005 Free Software Foundation
#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# $Id: setup.py,v 1.34 2003/10/21 11:10:03 reinhard Exp $

import sys
import os

from src import PACKAGE, VERSION

try:
  from gnue.common.setup import GSetup
except ImportError:
  print "You need GNUe-Common 0.5.2 or newer installed to install %s" % PACKAGE
  sys.exit (1)

# =============================================================================

class setup (GSetup.GSetup):

  package = PACKAGE.lower()

  # ---------------------------------------------------------------------------
  # Definition of basic parameters for distribution and installation.
  # Please add new files/directories that should be installed here.
  # Note that you also have to add them to MANIFEST.in.
  # ---------------------------------------------------------------------------

  def set_params (self, params):
  
    # The Work
    params ["name"]             = self.package
    params ["version"]          = VERSION
    params ["description"]      = "GNU Enterprise Application Server"
    params ["long_description"] = ""
    params ["license"]          = "GPL"

    # The Author
    params ["author"]       = "GNU Enterprise Team"
    params ["author_email"] = "gnue-dev@gnu.org"
    params ["url"]          = "http://www.gnue.org"

    # The Programs
    if sys.platform == 'win32':
      setupdb = "scripts/gnue-setupdb.bat"
    else:
      setupdb = "scripts/gnue-setupdb"
      
    params ["package_dir"] = {"gnue.appserver": "src"}
    params ["scripts"]     = [setupdb,
                              "scripts/gnue-appserver",
                              "scripts/gnue-gsdgen",
                              "scripts/gnue-readgcd",
                              "scripts/gnue-readgld"]

    # The Data
    datafiles   = self.allfiles ("share")
    wfefiles    = self.allfiles ("extensions/webfrontend")
    wfeimages   = self.allfiles ("extensions/webfrontend/images")
    grpcfiles   = ["grpc/appserver.grpc"]
    man1files   = self.allfiles ("doc/man")
    docfiles    = ["doc/configuration.txt",
                   "doc/gcd.dtd",
                   "doc/gld.dtd",
                   "doc/api/api.txt",
                   "doc/devguide/devguide.txt"]
    samplefiles = self.allfiles ("samples")

    params ["data_files"] = \
      [("share/gnue/appserver",                    datafiles),
       ("share/gnue/appserver/webfrontend",        wfefiles),
       ("share/gnue/appserver/webfrontend/images", wfeimages),
       ("share/gnue/grpc",                         grpcfiles),
       ("share/man/man1",                          man1files),
       ("share/doc/gnue-appserver",                docfiles),
       ("share/doc/gnue-appserver/examples",       samplefiles)]

  # ---------------------------------------------------------------------------
  # Build files to be distributed and installed:
  # Should generate the files that go in a distribution but aren't in SVN.
  # Gets called on sdist (always) and on build/install (only when run from SVN).
  # ---------------------------------------------------------------------------

  def build_files (self, action):

    # all this only works on posix systems :-(
    if os.name != "posix":
      return

    # First check if we have everything installed we need to build the
    # distribution

    # Texinfo
    if os.system ("makeinfo --version > /dev/null") != 0:
      print "Could not find 'makeinfo'. Please install Texinfo 4.0 or greater."
      sys.exit (1)

    if action == 'sdist':
      # create-technote-index from gnue-common/utils
      file = "../gnue-common/utils/create-technote-index.py"
      if not os.path.isfile (file):
        print "Could not find file '%s'." % file
        print "Please download gnue-common 0.5.0 or greater."
        sys.exit (1)

    # -------------------------------------------------------------------------

    # Build documentation
    print "building documentation: doc/api"
    if os.system ("cd doc/api && make txt") != 0:
      sys.exit (1)

    print "building documentation: doc/devguide"
    if os.system ("cd doc/devguide && make devguide.txt") != 0:
      sys.exit (1)

    if action == 'sdist':
      print "building documentation: doc/technotes"
      if os.system ("cd doc/technotes && make") != 0:
        sys.exit (1)

  # ---------------------------------------------------------------------------
  # Check dependencies for installation:
  # Should sys.exit(1) in case any requirement isn't met.
  # Gets called on install.
  # ---------------------------------------------------------------------------

  def check_dependencies (self):

    # -------------------------------------------------------------------------
    # xml
    try:
      print "checking Python xml library"
      import xml
    except ImportError:
      print "---"
      print "Could not import the xml package.  " \
            + "Please install Python's XML library."
      print "The file 'INSTALL' contains more information about dependencies."
      sys.exit (1)

    # -------------------------------------------------------------------------
    # mx.DateTime
    try:
      print "checking Python mx.DateTime library"
      import mx.DateTime
    except ImportError:
      print "---"
      print "Could not import the mx.DateTime package.  " \
            + "Please install the Egenix mx tools library."
      print "The file 'INSTALL' contains more information about dependencies."
      sys.exit (1)

    # -------------------------------------------------------------------------
    # Verify at least one RPC driver is installed
    RPCOK = 0

    # xmlrpc
    print "checking Python xmlrpc library (py-xmlrpc)"
    try:
      import xmlrpc
      RPCOK = 1
    except ImportError:
      pass

    # pw_xmlrpc
    print "checking Python xmlrpclib library (pw-xmlrpc)"
    try:
      import xmlrpclib
      RPCOK = 1
    except ImportError:
      pass

    # found any?
    if RPCOK != 1:
      print "---"
      print """
No valid GNURRPC drivers are installed on this machine.
Please install one of the following packages.
   py-xmlrpc         - http://sourceforge.net/projects/py-xmlrpc
   Pythonware XMLRPC - http://www.pythonware.com/products/xmlrpc
The file 'INSTALL' contains more information about dependencies.
"""
      sys.exit (1)

# =============================================================================

if __name__ == "__main__":
  setup().run()
