
-- ===========================================================================
-- This file was generated by gnue-schema
-- from sample.gsd on 2004-04-11 21:45:20.57 UTC.
-- 
-- Do NOT edit manually!
-- ===========================================================================

-- ===========================================================================
-- Client encoding set to 'UTF-8'
-- ===========================================================================

-- ===========================================================================
-- Create table 'gnue_property'
-- ===========================================================================
CREATE TABLE gnue_property (
  gnue_class varchar (32) NOT NULL,
  gnue_comment varchar (70),
  gnue_id varchar (32) NOT NULL,
  gnue_length int,
  gnue_module varchar (32) NOT NULL,
  gnue_name varchar (35) NOT NULL,
  gnue_nullable tinyint (1) unsigned NOT NULL,
  gnue_scale smallint,
  gnue_type varchar (35) NOT NULL,
  CONSTRAINT gnue_id_pk_gnue_property PRIMARY KEY (gnue_id)
);

-- ===========================================================================
-- Create table 'gnue_procedure'
-- ===========================================================================
CREATE TABLE gnue_procedure (
  gnue_class varchar (32) NOT NULL,
  gnue_code text NOT NULL,
  gnue_comment varchar (70),
  gnue_compiledcode text,
  gnue_id varchar (32) NOT NULL,
  gnue_language varchar (10) NOT NULL,
  gnue_module varchar (32) NOT NULL,
  gnue_name varchar (35) NOT NULL,
  CONSTRAINT gnue_id_pk_gnue_procedure PRIMARY KEY (gnue_id)
);

-- ===========================================================================
-- Create table 'gnue_class'
-- ===========================================================================
CREATE TABLE gnue_class (
  gnue_comment varchar (70),
  gnue_id varchar (32) NOT NULL,
  gnue_module varchar (32) NOT NULL,
  gnue_name varchar (35) NOT NULL,
  CONSTRAINT gnue_id_pk_gnue_class PRIMARY KEY (gnue_id)
);

-- ===========================================================================
-- Create table 'gnue_parameter'
-- ===========================================================================
CREATE TABLE gnue_parameter (
  gnue_comment varchar (70),
  gnue_id varchar (32) NOT NULL,
  gnue_length int,
  gnue_name varchar (35) NOT NULL,
  gnue_procedure varchar (32) NOT NULL,
  gnue_scale smallint,
  gnue_type varchar (35) NOT NULL,
  CONSTRAINT gnue_id_pk_gnue_parameter PRIMARY KEY (gnue_id)
);

-- ===========================================================================
-- Create table 'gnue_useraccess'
-- ===========================================================================
CREATE TABLE gnue_useraccess (
  gnue_accesslist varchar (100),
  gnue_id varchar (32) NOT NULL,
  gnue_password varchar (70),
  gnue_username varchar (20) NOT NULL,
  CONSTRAINT gnue_id_pk_gnue_useraccess PRIMARY KEY (gnue_id)
);

-- ===========================================================================
-- Create table 'address_person'
-- ===========================================================================
CREATE TABLE address_person (
  address_born date,
  address_children smallint,
  address_city varchar (35),
  address_country varchar (32),
  address_human tinyint (1) unsigned,
  address_lastmeeting datetime,
  address_meettime time,
  address_name varchar (35),
  address_street varchar (35),
  address_weight decimal (4,1),
  address_zip varchar (35),
  gnue_id varchar (32) NOT NULL,
  CONSTRAINT gnue_id_pk_address_person PRIMARY KEY (gnue_id)
);

-- ===========================================================================
-- Create table 'gnue_module'
-- ===========================================================================
CREATE TABLE gnue_module (
  gnue_comment varchar (70),
  gnue_id varchar (32) NOT NULL,
  gnue_name varchar (35) NOT NULL,
  CONSTRAINT gnue_id_pk_gnue_module PRIMARY KEY (gnue_id)
);

-- ===========================================================================
-- Create table 'address_country'
-- ===========================================================================
CREATE TABLE address_country (
  address_code varchar (2),
  address_name varchar (35),
  gnue_id varchar (32) NOT NULL,
  CONSTRAINT gnue_id_pk_address_country PRIMARY KEY (gnue_id)
);

-- ===========================================================================
-- Data for 'gnue_module'
-- ===========================================================================
INSERT INTO gnue_module (gnue_id, gnue_name, gnue_comment) VALUES ('00000000000000000000000000000000', 'gnue', 'GNU Enterprise System Management');

-- ===========================================================================
-- Data for 'gnue_class'
-- ===========================================================================
INSERT INTO gnue_class (gnue_id, gnue_module, gnue_name, gnue_comment) VALUES ('00000000000000000000000000000010', '00000000000000000000000000000000', 'module', 'GNU Enterprise Business Object Module');
INSERT INTO gnue_class (gnue_id, gnue_module, gnue_name, gnue_comment) VALUES ('00000000000000000000000000000020', '00000000000000000000000000000000', 'class', 'GNU Enterprise Business Object Class');
INSERT INTO gnue_class (gnue_id, gnue_module, gnue_name, gnue_comment) VALUES ('00000000000000000000000000000030', '00000000000000000000000000000000', 'property', 'GNU Enterprise Business Object Property');
INSERT INTO gnue_class (gnue_id, gnue_module, gnue_name, gnue_comment) VALUES ('00000000000000000000000000000040', '00000000000000000000000000000000', 'procedure', 'GNU Enterprise Business Object Procedure');
INSERT INTO gnue_class (gnue_id, gnue_module, gnue_name, gnue_comment) VALUES ('00000000000000000000000000000050', '00000000000000000000000000000000', 'parameter', 'GNU Enterprise Business Object Procedure Parameter');

-- ===========================================================================
-- Data for 'gnue_property'
-- ===========================================================================
INSERT INTO gnue_property (gnue_id, gnue_module, gnue_class, gnue_name, gnue_type, gnue_length, gnue_comment, gnue_nullable) VALUES ('00000000000000000000000000000013', '00000000000000000000000000000000', '00000000000000000000000000000010', 'comment', 'string', 70, 'Comment', 1);
INSERT INTO gnue_property (gnue_id, gnue_module, gnue_class, gnue_name, gnue_type, gnue_comment, gnue_nullable) VALUES ('00000000000000000000000000000011', '00000000000000000000000000000000', '00000000000000000000000000000010', 'id', 'id', 'Object ID', 0);
INSERT INTO gnue_property (gnue_id, gnue_module, gnue_class, gnue_name, gnue_type, gnue_length, gnue_comment, gnue_nullable) VALUES ('00000000000000000000000000000012', '00000000000000000000000000000000', '00000000000000000000000000000010', 'name', 'string', 35, 'Name', 0);
INSERT INTO gnue_property (gnue_id, gnue_module, gnue_class, gnue_name, gnue_type, gnue_length, gnue_comment, gnue_nullable) VALUES ('00000000000000000000000000000024', '00000000000000000000000000000000', '00000000000000000000000000000020', 'comment', 'string', 70, 'Comment', 1);
INSERT INTO gnue_property (gnue_id, gnue_module, gnue_class, gnue_name, gnue_type, gnue_comment, gnue_nullable) VALUES ('00000000000000000000000000000021', '00000000000000000000000000000000', '00000000000000000000000000000020', 'id', 'id', 'Object ID', 0);
INSERT INTO gnue_property (gnue_id, gnue_module, gnue_class, gnue_name, gnue_type, gnue_comment, gnue_nullable) VALUES ('00000000000000000000000000000022', '00000000000000000000000000000000', '00000000000000000000000000000020', 'module', 'gnue_module', 'Module that defined this class', 0);
INSERT INTO gnue_property (gnue_id, gnue_module, gnue_class, gnue_name, gnue_type, gnue_length, gnue_comment, gnue_nullable) VALUES ('00000000000000000000000000000023', '00000000000000000000000000000000', '00000000000000000000000000000020', 'name', 'string', 35, 'Classname without modulename', 0);
INSERT INTO gnue_property (gnue_id, gnue_module, gnue_class, gnue_name, gnue_type, gnue_comment, gnue_nullable) VALUES ('00000000000000000000000000000032', '00000000000000000000000000000000', '00000000000000000000000000000030', 'class', 'gnue_class', 'Class the property belongs to', 0);
INSERT INTO gnue_property (gnue_id, gnue_module, gnue_class, gnue_name, gnue_type, gnue_length, gnue_comment, gnue_nullable) VALUES ('00000000000000000000000000000038', '00000000000000000000000000000000', '00000000000000000000000000000030', 'comment', 'string', 70, 'Comment', 1);
INSERT INTO gnue_property (gnue_id, gnue_module, gnue_class, gnue_name, gnue_type, gnue_comment, gnue_nullable) VALUES ('00000000000000000000000000000031', '00000000000000000000000000000000', '00000000000000000000000000000030', 'id', 'id', 'Object ID', 0);
INSERT INTO gnue_property (gnue_id, gnue_module, gnue_class, gnue_name, gnue_type, gnue_length, gnue_comment, gnue_nullable) VALUES ('00000000000000000000000000000036', '00000000000000000000000000000000', '00000000000000000000000000000030', 'length', 'number', 6, 'Lenght of the property', 1);
INSERT INTO gnue_property (gnue_id, gnue_module, gnue_class, gnue_name, gnue_type, gnue_comment, gnue_nullable) VALUES ('00000000000000000000000000000033', '00000000000000000000000000000000', '00000000000000000000000000000030', 'module', 'gnue_module', 'Module that defined this property', 0);
INSERT INTO gnue_property (gnue_id, gnue_module, gnue_class, gnue_name, gnue_type, gnue_length, gnue_comment, gnue_nullable) VALUES ('00000000000000000000000000000034', '00000000000000000000000000000000', '00000000000000000000000000000030', 'name', 'string', 35, 'Propertyname without modulename', 0);
INSERT INTO gnue_property (gnue_id, gnue_module, gnue_class, gnue_name, gnue_type, gnue_comment, gnue_nullable) VALUES ('00000000000000000000000000000039', '00000000000000000000000000000000', '00000000000000000000000000000030', 'nullable', 'boolean', 'Property can contain NULL values', 0);
INSERT INTO gnue_property (gnue_id, gnue_module, gnue_class, gnue_name, gnue_type, gnue_length, gnue_comment, gnue_nullable) VALUES ('00000000000000000000000000000037', '00000000000000000000000000000000', '00000000000000000000000000000030', 'scale', 'number', 4, 'Scale of numeric data', 1);
INSERT INTO gnue_property (gnue_id, gnue_module, gnue_class, gnue_name, gnue_type, gnue_length, gnue_comment, gnue_nullable) VALUES ('00000000000000000000000000000035', '00000000000000000000000000000000', '00000000000000000000000000000030', 'type', 'string', 35, 'Property type', 0);
INSERT INTO gnue_property (gnue_id, gnue_module, gnue_class, gnue_name, gnue_type, gnue_comment, gnue_nullable) VALUES ('00000000000000000000000000000042', '00000000000000000000000000000000', '00000000000000000000000000000040', 'class', 'gnue_class', 'Class the procedure belongs to', 0);
INSERT INTO gnue_property (gnue_id, gnue_module, gnue_class, gnue_name, gnue_type, gnue_comment, gnue_nullable) VALUES ('00000000000000000000000000000046', '00000000000000000000000000000000', '00000000000000000000000000000040', 'code', 'string', 'Procedure code', 0);
INSERT INTO gnue_property (gnue_id, gnue_module, gnue_class, gnue_name, gnue_type, gnue_length, gnue_comment, gnue_nullable) VALUES ('00000000000000000000000000000048', '00000000000000000000000000000000', '00000000000000000000000000000040', 'comment', 'string', 70, 'Comment', 1);
INSERT INTO gnue_property (gnue_id, gnue_module, gnue_class, gnue_name, gnue_type, gnue_comment, gnue_nullable) VALUES ('00000000000000000000000000000047', '00000000000000000000000000000000', '00000000000000000000000000000040', 'compiledcode', 'string', 'Compiled procedure code', 1);
INSERT INTO gnue_property (gnue_id, gnue_module, gnue_class, gnue_name, gnue_type, gnue_comment, gnue_nullable) VALUES ('00000000000000000000000000000041', '00000000000000000000000000000000', '00000000000000000000000000000040', 'id', 'id', 'Object ID', 0);
INSERT INTO gnue_property (gnue_id, gnue_module, gnue_class, gnue_name, gnue_type, gnue_length, gnue_comment, gnue_nullable) VALUES ('00000000000000000000000000000045', '00000000000000000000000000000000', '00000000000000000000000000000040', 'language', 'string', 10, 'Procedure language', 0);
INSERT INTO gnue_property (gnue_id, gnue_module, gnue_class, gnue_name, gnue_type, gnue_comment, gnue_nullable) VALUES ('00000000000000000000000000000043', '00000000000000000000000000000000', '00000000000000000000000000000040', 'module', 'gnue_module', 'Module that defined this procedure', 0);
INSERT INTO gnue_property (gnue_id, gnue_module, gnue_class, gnue_name, gnue_type, gnue_length, gnue_comment, gnue_nullable) VALUES ('00000000000000000000000000000044', '00000000000000000000000000000000', '00000000000000000000000000000040', 'name', 'string', 35, 'Procedurename without modulename', 0);
INSERT INTO gnue_property (gnue_id, gnue_module, gnue_class, gnue_name, gnue_type, gnue_length, gnue_comment, gnue_nullable) VALUES ('00000000000000000000000000000057', '00000000000000000000000000000000', '00000000000000000000000000000050', 'comment', 'string', 70, 'Comment', 1);
INSERT INTO gnue_property (gnue_id, gnue_module, gnue_class, gnue_name, gnue_type, gnue_comment, gnue_nullable) VALUES ('00000000000000000000000000000051', '00000000000000000000000000000000', '00000000000000000000000000000050', 'id', 'id', 'Object ID', 0);
INSERT INTO gnue_property (gnue_id, gnue_module, gnue_class, gnue_name, gnue_type, gnue_length, gnue_comment, gnue_nullable) VALUES ('00000000000000000000000000000055', '00000000000000000000000000000000', '00000000000000000000000000000050', 'length', 'number', 6, 'Lenght of the parameter', 1);
INSERT INTO gnue_property (gnue_id, gnue_module, gnue_class, gnue_name, gnue_type, gnue_length, gnue_comment, gnue_nullable) VALUES ('00000000000000000000000000000053', '00000000000000000000000000000000', '00000000000000000000000000000050', 'name', 'string', 35, 'Name of the parameter', 0);
INSERT INTO gnue_property (gnue_id, gnue_module, gnue_class, gnue_name, gnue_type, gnue_comment, gnue_nullable) VALUES ('00000000000000000000000000000052', '00000000000000000000000000000000', '00000000000000000000000000000050', 'procedure', 'gnue_procedure', 'Procedure the parameter belongs to', 0);
INSERT INTO gnue_property (gnue_id, gnue_module, gnue_class, gnue_name, gnue_type, gnue_length, gnue_comment, gnue_nullable) VALUES ('00000000000000000000000000000056', '00000000000000000000000000000000', '00000000000000000000000000000050', 'scale', 'number', 4, 'Scale of numeric data', 1);
INSERT INTO gnue_property (gnue_id, gnue_module, gnue_class, gnue_name, gnue_type, gnue_length, gnue_comment, gnue_nullable) VALUES ('00000000000000000000000000000054', '00000000000000000000000000000000', '00000000000000000000000000000050', 'type', 'string', 35, 'Parameter type', 0);

-- ===========================================================================
-- Data for 'gnue_procedure'
-- ===========================================================================

-- ===========================================================================
-- Data for 'gnue_class'
-- ===========================================================================
INSERT INTO gnue_class (gnue_id, gnue_module, gnue_name, gnue_comment) VALUES ('00000000000000000000000000000060', '00000000000000000000000000000000', 'useraccess', 'GNU Enterprise User Authentication');

-- ===========================================================================
-- Data for 'gnue_property'
-- ===========================================================================
INSERT INTO gnue_property (gnue_id, gnue_module, gnue_class, gnue_name, gnue_type, gnue_length, gnue_scale, gnue_comment, gnue_nullable) VALUES ('00000000000000000000000000000064', '00000000000000000000000000000000', '00000000000000000000000000000060', 'accesslist', 'string', 100, 0, 'List of classes with access allowed', 1);
INSERT INTO gnue_property (gnue_id, gnue_module, gnue_class, gnue_name, gnue_type, gnue_length, gnue_scale, gnue_comment, gnue_nullable) VALUES ('00000000000000000000000000000061', '00000000000000000000000000000000', '00000000000000000000000000000060', 'id', 'id', 0, 0, 'Object ID', 0);
INSERT INTO gnue_property (gnue_id, gnue_module, gnue_class, gnue_name, gnue_type, gnue_length, gnue_scale, gnue_comment, gnue_nullable) VALUES ('00000000000000000000000000000063', '00000000000000000000000000000000', '00000000000000000000000000000060', 'password', 'string', 70, 0, 'Password', 1);
INSERT INTO gnue_property (gnue_id, gnue_module, gnue_class, gnue_name, gnue_type, gnue_length, gnue_scale, gnue_comment, gnue_nullable) VALUES ('00000000000000000000000000000062', '00000000000000000000000000000000', '00000000000000000000000000000060', 'username', 'string', 20, 0, 'Username', 0);

-- ===========================================================================
-- Data for 'gnue_procedure'
-- ===========================================================================

-- ===========================================================================
-- Data for 'gnue_module'
-- ===========================================================================
INSERT INTO gnue_module (gnue_id, gnue_name, gnue_comment) VALUES ('00000000000000000000000000001000', 'address', 'Address Management');

-- ===========================================================================
-- Data for 'gnue_class'
-- ===========================================================================
INSERT INTO gnue_class (gnue_id, gnue_module, gnue_name, gnue_comment) VALUES ('00000000000000000000000000001020', '00000000000000000000000000001000', 'country', 'Country');
INSERT INTO gnue_class (gnue_id, gnue_module, gnue_name, gnue_comment) VALUES ('00000000000000000000000000001010', '00000000000000000000000000001000', 'person', 'Person');

-- ===========================================================================
-- Data for 'gnue_property'
-- ===========================================================================
INSERT INTO gnue_property (gnue_id, gnue_module, gnue_class, gnue_name, gnue_type, gnue_length, gnue_comment, gnue_nullable) VALUES ('00000000000000000000000000001022', '00000000000000000000000000001000', '00000000000000000000000000001020', 'code', 'string', 2, 'ISO-Country code', 1);
INSERT INTO gnue_property (gnue_id, gnue_module, gnue_class, gnue_name, gnue_type, gnue_length, gnue_comment, gnue_nullable) VALUES ('00000000000000000000000000001023', '00000000000000000000000000001000', '00000000000000000000000000001020', 'name', 'string', 35, 'The name of the country', 1);
INSERT INTO gnue_property (gnue_id, gnue_module, gnue_class, gnue_name, gnue_type, gnue_comment, gnue_nullable) VALUES ('00000000000000000000000000001021', '00000000000000000000000000000000', '00000000000000000000000000001020', 'id', 'id', 'Object ID', 0);
INSERT INTO gnue_property (gnue_id, gnue_module, gnue_class, gnue_name, gnue_type, gnue_comment, gnue_nullable) VALUES ('00000000000000000000000000001019', '00000000000000000000000000001000', '00000000000000000000000000001010', 'born', 'date', 'Birthday', 1);
INSERT INTO gnue_property (gnue_id, gnue_module, gnue_class, gnue_name, gnue_type, gnue_length, gnue_comment, gnue_nullable) VALUES ('00000000000000000000000000001017', '00000000000000000000000000001000', '00000000000000000000000000001010', 'children', 'number', 2, 'Number of children', 1);
INSERT INTO gnue_property (gnue_id, gnue_module, gnue_class, gnue_name, gnue_type, gnue_length, gnue_comment, gnue_nullable) VALUES ('00000000000000000000000000001015', '00000000000000000000000000001000', '00000000000000000000000000001010', 'city', 'string', 35, 'City where the person lives', 1);
INSERT INTO gnue_property (gnue_id, gnue_module, gnue_class, gnue_name, gnue_type, gnue_length, gnue_comment, gnue_nullable) VALUES ('00000000000000000000000000001016', '00000000000000000000000000001000', '00000000000000000000000000001010', 'country', 'address_country', 32, 'Country where the person lives', 1);
INSERT INTO gnue_property (gnue_id, gnue_module, gnue_class, gnue_name, gnue_type, gnue_comment, gnue_nullable) VALUES ('0000000000000000000000000000101C', '00000000000000000000000000001000', '00000000000000000000000000001010', 'human', 'boolean', 'Whether the person is human or not', 1);
INSERT INTO gnue_property (gnue_id, gnue_module, gnue_class, gnue_name, gnue_type, gnue_comment, gnue_nullable) VALUES ('0000000000000000000000000000101B', '00000000000000000000000000001000', '00000000000000000000000000001010', 'lastmeeting', 'datetime', 'Date and time of the last meeting', 1);
INSERT INTO gnue_property (gnue_id, gnue_module, gnue_class, gnue_name, gnue_type, gnue_comment, gnue_nullable) VALUES ('0000000000000000000000000000101A', '00000000000000000000000000001000', '00000000000000000000000000001010', 'meettime', 'time', 'Preferred time for meetings', 1);
INSERT INTO gnue_property (gnue_id, gnue_module, gnue_class, gnue_name, gnue_type, gnue_length, gnue_comment, gnue_nullable) VALUES ('00000000000000000000000000001012', '00000000000000000000000000001000', '00000000000000000000000000001010', 'name', 'string', 35, 'Name of the person', 1);
INSERT INTO gnue_property (gnue_id, gnue_module, gnue_class, gnue_name, gnue_type, gnue_length, gnue_comment, gnue_nullable) VALUES ('00000000000000000000000000001013', '00000000000000000000000000001000', '00000000000000000000000000001010', 'street', 'string', 35, 'Street where the person lives', 1);
INSERT INTO gnue_property (gnue_id, gnue_module, gnue_class, gnue_name, gnue_type, gnue_length, gnue_scale, gnue_comment, gnue_nullable) VALUES ('00000000000000000000000000001018', '00000000000000000000000000001000', '00000000000000000000000000001010', 'weight', 'number', 4, 1, 'Weight of the person in kg', 1);
INSERT INTO gnue_property (gnue_id, gnue_module, gnue_class, gnue_name, gnue_type, gnue_length, gnue_comment, gnue_nullable) VALUES ('00000000000000000000000000001014', '00000000000000000000000000001000', '00000000000000000000000000001010', 'zip', 'string', 35, 'Zip code of the city where the person lives', 1);
INSERT INTO gnue_property (gnue_id, gnue_module, gnue_class, gnue_name, gnue_type, gnue_comment, gnue_nullable) VALUES ('00000000000000000000000000001011', '00000000000000000000000000000000', '00000000000000000000000000001010', 'id', 'id', 'Object ID', 0);

-- ===========================================================================
-- Data for 'gnue_procedure'
-- ===========================================================================
INSERT INTO gnue_procedure (gnue_id, gnue_module, gnue_class, gnue_name, gnue_language, gnue_code, gnue_comment) VALUES ('0000000000000000000000000000101F', '00000000000000000000000000001000', '00000000000000000000000000001010', 'show', 'python', 'print self.address_name', 'Simple procedure to test Appserver');
INSERT INTO gnue_procedure (gnue_id, gnue_module, gnue_class, gnue_name, gnue_language, gnue_code, gnue_comment) VALUES ('0000000000000000000000000000101E', '00000000000000000000000000001000', '00000000000000000000000000001010', 'test', 'python', '
if self.address_name [0] == "(":
  self.address_name = self.address_name [1:len(self.address_name)-1]
else:
  self.address_name = "(" + self.address_name + ")"
          ', 'Simple procedure to test Appserver');

-- ===========================================================================
-- Data for 'gnue_useraccess'
-- ===========================================================================
INSERT INTO gnue_useraccess (gnue_id, gnue_username, gnue_password, gnue_accesslist) VALUES ('00000000000000000000001000000001', 'test', 'test', 'address_person,address_country');
INSERT INTO gnue_useraccess (gnue_id, gnue_username, gnue_password, gnue_accesslist) VALUES ('00000000000000000000001000000002', 'hacker', 'secret', 'all');

-- ===========================================================================
-- Data for 'address_person'
-- ===========================================================================
INSERT INTO address_person (gnue_id, address_name, address_street, address_zip, address_city, address_country, address_children, address_weight, address_born, address_meettime, address_lastmeeting, address_human) VALUES ('00000000000000000000000000001100', 'James T. Kirk', 'Enterprise Road 17', '2002', 'Gnutown', '00000000000000000000002000000002', 1, 85.4, '2233-03-21', '19:00:00.00', '2270-05-31 18:30:00.00', 1);
INSERT INTO address_person (gnue_id, address_name, address_street, address_zip, address_city, address_country, address_children, address_weight, address_born, address_meettime, address_lastmeeting, address_human) VALUES ('00000000000000000000000000001101', 'Mr. Spock', 'Vulc Lane 1', '4711', 'Vulcane', '00000000000000000000002000000001', 0, 78.8, '2230-01-01', '06:30:00.00', '2270-05-17 08:00:00.00', 0);

-- ===========================================================================
-- Data for 'address_country'
-- ===========================================================================
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('00000000000000000000002000000001', 'AF', 'Afghanistan');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('00000000000000000000002000000002', 'AX', 'Aland Islands');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('00000000000000000000002000000003', 'AL', 'Albania');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('00000000000000000000002000000004', 'DZ', 'Algeria');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('00000000000000000000002000000005', 'AS', 'American Samoa');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('00000000000000000000002000000006', 'AD', 'Andorra');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('00000000000000000000002000000007', 'AO', 'Angola');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('00000000000000000000002000000008', 'AI', 'Anguilla');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('00000000000000000000002000000009', 'AQ', 'Antarctica');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('0000000000000000000000200000000A', 'AG', 'Antigua And Barbuda');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('0000000000000000000000200000000B', 'AR', 'Argentina');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('0000000000000000000000200000000C', 'AM', 'Armenia');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('0000000000000000000000200000000D', 'AW', 'Aruba');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('0000000000000000000000200000000E', 'AU', 'Australia');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('0000000000000000000000200000000F', 'AT', 'Austria');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('00000000000000000000002000000010', 'AZ', 'Azerbaijan');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('00000000000000000000002000000011', 'BS', 'Bahamas');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('00000000000000000000002000000012', 'BH', 'Bahrain');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('00000000000000000000002000000013', 'BD', 'Bangladesh');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('00000000000000000000002000000014', 'BB', 'Barbados');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('00000000000000000000002000000015', 'BY', 'Belarus');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('00000000000000000000002000000016', 'BE', 'Belgium');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('00000000000000000000002000000017', 'BZ', 'Belize');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('00000000000000000000002000000018', 'BJ', 'Benin');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('00000000000000000000002000000019', 'BM', 'Bermuda');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('0000000000000000000000200000001A', 'BT', 'Bhutan');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('0000000000000000000000200000001B', 'BO', 'Bolivia');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('0000000000000000000000200000001C', 'BA', 'Bosnia And Herzegovina');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('0000000000000000000000200000001D', 'BW', 'Botswana');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('0000000000000000000000200000001E', 'BV', 'Bouvet Island');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('0000000000000000000000200000001F', 'BR', 'Brazil');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('00000000000000000000002000000020', 'IO', 'British Indian Ocean Territory');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('00000000000000000000002000000021', 'BN', 'Brunei Darussalam');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('00000000000000000000002000000022', 'BG', 'Bulgaria');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('00000000000000000000002000000023', 'BF', 'Burkina Faso');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('00000000000000000000002000000024', 'BI', 'Burundi');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('00000000000000000000002000000025', 'KH', 'Cambodia');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('00000000000000000000002000000026', 'CM', 'Cameroon');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('00000000000000000000002000000027', 'CA', 'Canada');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('00000000000000000000002000000028', 'CV', 'Cape Verde');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('00000000000000000000002000000029', 'KY', 'Cayman Islands');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('0000000000000000000000200000002A', 'CF', 'Central African Republic');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('0000000000000000000000200000002B', 'TD', 'Chad');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('0000000000000000000000200000002C', 'CL', 'Chile');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('0000000000000000000000200000002D', 'CN', 'China');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('0000000000000000000000200000002E', 'CX', 'Christmas Island');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('0000000000000000000000200000002F', 'CC', 'Cocos (Keeling) Islands');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('00000000000000000000002000000030', 'CO', 'Colombia');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('00000000000000000000002000000031', 'KM', 'Comoros');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('00000000000000000000002000000032', 'CG', 'Congo');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('00000000000000000000002000000033', 'CD', 'Congo, The Democratic Republic Of T');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('00000000000000000000002000000034', 'CK', 'Cook Islands');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('00000000000000000000002000000035', 'CR', 'Costa Rica');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('00000000000000000000002000000036', 'CI', 'Cote D\'Ivoire');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('00000000000000000000002000000037', 'HR', 'Croatia');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('00000000000000000000002000000038', 'CU', 'Cuba');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('00000000000000000000002000000039', 'CY', 'Cyprus');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('0000000000000000000000200000003A', 'CZ', 'Czech Republic');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('0000000000000000000000200000003B', 'DK', 'Denmark');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('0000000000000000000000200000003C', 'DJ', 'Djibouti');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('0000000000000000000000200000003D', 'DM', 'Dominica');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('0000000000000000000000200000003E', 'DO', 'Dominican Republic');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('0000000000000000000000200000003F', 'EC', 'Ecuador');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('00000000000000000000002000000040', 'EG', 'Egypt');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('00000000000000000000002000000041', 'SV', 'El Salvador');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('00000000000000000000002000000042', 'GQ', 'Equatorial Guinea');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('00000000000000000000002000000043', 'ER', 'Eritrea');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('00000000000000000000002000000044', 'EE', 'Estonia');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('00000000000000000000002000000045', 'ET', 'Ethiopia');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('00000000000000000000002000000046', 'FK', 'Falkland Islands (Malvinas)');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('00000000000000000000002000000047', 'FO', 'Faroe Islands');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('00000000000000000000002000000048', 'FJ', 'Fiji');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('00000000000000000000002000000049', 'FI', 'Finland');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('0000000000000000000000200000004A', 'FR', 'France');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('0000000000000000000000200000004B', 'GF', 'French Guiana');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('0000000000000000000000200000004C', 'PF', 'French Polynesia');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('0000000000000000000000200000004D', 'TF', 'French Southern Territories');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('0000000000000000000000200000004E', 'GA', 'Gabon');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('0000000000000000000000200000004F', 'GM', 'Gambia');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('00000000000000000000002000000050', 'GE', 'Georgia');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('00000000000000000000002000000051', 'DE', 'Germany');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('00000000000000000000002000000052', 'GH', 'Ghana');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('00000000000000000000002000000053', 'GI', 'Gibraltar');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('00000000000000000000002000000054', 'GR', 'Greece');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('00000000000000000000002000000055', 'GL', 'Greenland');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('00000000000000000000002000000056', 'GD', 'Grenada');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('00000000000000000000002000000057', 'GP', 'Guadeloupe');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('00000000000000000000002000000058', 'GU', 'Guam');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('00000000000000000000002000000059', 'GT', 'Guatemala');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('0000000000000000000000200000005A', 'GN', 'Guinea');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('0000000000000000000000200000005B', 'GW', 'Guinea-Bissau');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('0000000000000000000000200000005C', 'GY', 'Guyana');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('0000000000000000000000200000005D', 'HT', 'Haiti');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('0000000000000000000000200000005E', 'HM', 'Heard Island And Mcdonald Islands');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('0000000000000000000000200000005F', 'VA', 'Holy See (Vatican City State)');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('00000000000000000000002000000060', 'HN', 'Honduras');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('00000000000000000000002000000061', 'HK', 'Hong Kong');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('00000000000000000000002000000062', 'HU', 'Hungary');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('00000000000000000000002000000063', 'IS', 'Iceland');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('00000000000000000000002000000064', 'IN', 'India');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('00000000000000000000002000000065', 'ID', 'Indonesia');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('00000000000000000000002000000066', 'IR', 'Iran, Islamic Republic Of');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('00000000000000000000002000000067', 'IQ', 'Iraq');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('00000000000000000000002000000068', 'IE', 'Ireland');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('00000000000000000000002000000069', 'IL', 'Israel');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('0000000000000000000000200000006A', 'IT', 'Italy');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('0000000000000000000000200000006B', 'JM', 'Jamaica');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('0000000000000000000000200000006C', 'JP', 'Japan');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('0000000000000000000000200000006D', 'JO', 'Jordan');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('0000000000000000000000200000006E', 'KZ', 'Kazakhstan');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('0000000000000000000000200000006F', 'KE', 'Kenya');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('00000000000000000000002000000070', 'KI', 'Kiribati');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('00000000000000000000002000000071', 'KP', 'Korea, Democratic People\'s Republic');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('00000000000000000000002000000072', 'KR', 'Korea, Republic Of');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('00000000000000000000002000000073', 'KW', 'Kuwait');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('00000000000000000000002000000074', 'KG', 'Kyrgyzstan');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('00000000000000000000002000000075', 'LA', 'Lao People\'s Democratic Republic');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('00000000000000000000002000000076', 'LV', 'Latvia');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('00000000000000000000002000000077', 'LB', 'Lebanon');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('00000000000000000000002000000078', 'LS', 'Lesotho');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('00000000000000000000002000000079', 'LR', 'Liberia');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('0000000000000000000000200000007A', 'LY', 'Libyan Arab Jamahiriya');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('0000000000000000000000200000007B', 'LI', 'Liechtenstein');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('0000000000000000000000200000007C', 'LT', 'Lithuania');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('0000000000000000000000200000007D', 'LU', 'Luxembourg');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('0000000000000000000000200000007E', 'MO', 'Macao');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('0000000000000000000000200000007F', 'MK', 'Macedonia, The Former Yugoslav Repu');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('00000000000000000000002000000080', 'MG', 'Madagascar');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('00000000000000000000002000000081', 'MW', 'Malawi');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('00000000000000000000002000000082', 'MY', 'Malaysia');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('00000000000000000000002000000083', 'MV', 'Maldives');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('00000000000000000000002000000084', 'ML', 'Mali');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('00000000000000000000002000000085', 'MT', 'Malta');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('00000000000000000000002000000086', 'MH', 'Marshall Islands');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('00000000000000000000002000000087', 'MQ', 'Martinique');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('00000000000000000000002000000088', 'MR', 'Mauritania');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('00000000000000000000002000000089', 'MU', 'Mauritius');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('0000000000000000000000200000008A', 'YT', 'Mayotte');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('0000000000000000000000200000008B', 'MX', 'Mexico');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('0000000000000000000000200000008C', 'FM', 'Micronesia, Federated States Of');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('0000000000000000000000200000008D', 'MD', 'Moldova, Republic Of');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('0000000000000000000000200000008E', 'MC', 'Monaco');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('0000000000000000000000200000008F', 'MN', 'Mongolia');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('00000000000000000000002000000090', 'MS', 'Montserrat');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('00000000000000000000002000000091', 'MA', 'Morocco');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('00000000000000000000002000000092', 'MZ', 'Mozambique');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('00000000000000000000002000000093', 'MM', 'Myanmar');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('00000000000000000000002000000094', 'NA', 'Namibia');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('00000000000000000000002000000095', 'NR', 'Nauru');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('00000000000000000000002000000096', 'NP', 'Nepal');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('00000000000000000000002000000097', 'NL', 'Netherlands');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('00000000000000000000002000000098', 'AN', 'Netherlands Antilles');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('00000000000000000000002000000099', 'NC', 'New Caledonia');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('0000000000000000000000200000009A', 'NZ', 'New Zealand');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('0000000000000000000000200000009B', 'NI', 'Nicaragua');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('0000000000000000000000200000009C', 'NE', 'Niger');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('0000000000000000000000200000009D', 'NG', 'Nigeria');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('0000000000000000000000200000009E', 'NU', 'Niue');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('0000000000000000000000200000009F', 'NF', 'Norfolk Island');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('000000000000000000000020000000A0', 'MP', 'Northern Mariana Islands');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('000000000000000000000020000000A1', 'NO', 'Norway');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('000000000000000000000020000000A2', 'OM', 'Oman');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('000000000000000000000020000000A3', 'PK', 'Pakistan');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('000000000000000000000020000000A4', 'PW', 'Palau');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('000000000000000000000020000000A5', 'PS', 'Palestinian Territory, Occupied');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('000000000000000000000020000000A6', 'PA', 'Panama');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('000000000000000000000020000000A7', 'PG', 'Papua New Guinea');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('000000000000000000000020000000A8', 'PY', 'Paraguay');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('000000000000000000000020000000A9', 'PE', 'Peru');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('000000000000000000000020000000AA', 'PH', 'Philippines');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('000000000000000000000020000000AB', 'PN', 'Pitcairn');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('000000000000000000000020000000AC', 'PL', 'Poland');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('000000000000000000000020000000AD', 'PT', 'Portugal');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('000000000000000000000020000000AE', 'PR', 'Puerto Rico');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('000000000000000000000020000000AF', 'QA', 'Qatar');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('000000000000000000000020000000B0', 'RE', 'Reunion');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('000000000000000000000020000000B1', 'RO', 'Romania');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('000000000000000000000020000000B2', 'RU', 'Russian Federation');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('000000000000000000000020000000B3', 'RW', 'Rwanda');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('000000000000000000000020000000B4', 'SH', 'Saint Helena');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('000000000000000000000020000000B5', 'KN', 'Saint Kitts And Nevis');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('000000000000000000000020000000B6', 'LC', 'Saint Lucia');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('000000000000000000000020000000B7', 'PM', 'Saint Pierre And Miquelon');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('000000000000000000000020000000B8', 'VC', 'Saint Vincent And The Grenadines');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('000000000000000000000020000000B9', 'WS', 'Samoa');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('000000000000000000000020000000BA', 'SM', 'San Marino');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('000000000000000000000020000000BB', 'ST', 'Sao Tome And Principe');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('000000000000000000000020000000BC', 'SA', 'Saudi Arabia');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('000000000000000000000020000000BD', 'SN', 'Senegal');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('000000000000000000000020000000BE', 'CS', 'Serbia And Montenegro');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('000000000000000000000020000000BF', 'SC', 'Seychelles');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('000000000000000000000020000000C0', 'SL', 'Sierra Leone');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('000000000000000000000020000000C1', 'SG', 'Singapore');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('000000000000000000000020000000C2', 'SK', 'Slovakia');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('000000000000000000000020000000C3', 'SI', 'Slovenia');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('000000000000000000000020000000C4', 'SB', 'Solomon Islands');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('000000000000000000000020000000C5', 'SO', 'Somalia');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('000000000000000000000020000000C6', 'ZA', 'South Africa');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('000000000000000000000020000000C7', 'GS', 'South Georgia And The South Sandwic');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('000000000000000000000020000000C8', 'ES', 'Spain');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('000000000000000000000020000000C9', 'LK', 'Sri Lanka');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('000000000000000000000020000000CA', 'SD', 'Sudan');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('000000000000000000000020000000CB', 'SR', 'Suriname');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('000000000000000000000020000000CC', 'SJ', 'Svalbard And Jan Mayen');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('000000000000000000000020000000CD', 'SZ', 'Swaziland');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('000000000000000000000020000000CE', 'SE', 'Sweden');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('000000000000000000000020000000CF', 'CH', 'Switzerland');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('000000000000000000000020000000D0', 'SY', 'Syrian Arab Republic');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('000000000000000000000020000000D1', 'TW', 'Taiwan, Province Of China');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('000000000000000000000020000000D2', 'TJ', 'Tajikistan');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('000000000000000000000020000000D3', 'TZ', 'Tanzania, United Republic Of');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('000000000000000000000020000000D4', 'TH', 'Thailand');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('000000000000000000000020000000D5', 'TL', 'Timor-Leste');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('000000000000000000000020000000D6', 'TG', 'Togo');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('000000000000000000000020000000D7', 'TK', 'Tokelau');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('000000000000000000000020000000D8', 'TO', 'Tonga');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('000000000000000000000020000000D9', 'TT', 'Trinidad And Tobago');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('000000000000000000000020000000DA', 'TN', 'Tunisia');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('000000000000000000000020000000DB', 'TR', 'Turkey');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('000000000000000000000020000000DC', 'TM', 'Turkmenistan');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('000000000000000000000020000000DD', 'TC', 'Turks And Caicos Islands');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('000000000000000000000020000000DE', 'TV', 'Tuvalu');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('000000000000000000000020000000DF', 'UG', 'Uganda');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('000000000000000000000020000000E0', 'UA', 'Ukraine');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('000000000000000000000020000000E1', 'AE', 'United Arab Emirates');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('000000000000000000000020000000E2', 'GB', 'United Kingdom');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('000000000000000000000020000000E3', 'US', 'United States');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('000000000000000000000020000000E4', 'UM', 'United States Minor Outlying Island');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('000000000000000000000020000000E5', 'UY', 'Uruguay');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('000000000000000000000020000000E6', 'UZ', 'Uzbekistan');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('000000000000000000000020000000E7', 'VU', 'Vanuatu');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('000000000000000000000020000000E8', 'VE', 'Venezuela');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('000000000000000000000020000000E9', 'VN', 'Viet Nam');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('000000000000000000000020000000EA', 'VG', 'Virgin Islands, British');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('000000000000000000000020000000EB', 'VI', 'Virgin Islands, U.S.');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('000000000000000000000020000000EC', 'WF', 'Wallis And Futuna');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('000000000000000000000020000000ED', 'EH', 'Western Sahara');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('000000000000000000000020000000EE', 'YE', 'Yemen');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('000000000000000000000020000000EF', 'ZM', 'Zambia');
INSERT INTO address_country (gnue_id, address_code, address_name) VALUES ('000000000000000000000020000000F0', 'ZW', 'Zimbabwe');
