/* vi:set ts=8 sts=0 sw=8:
 * $Id: project.h,v 1.8 1999/12/10 18:07:07 kahn Exp kahn $
 *
 * Copyright (C) 1998 Andy C. Kahn
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef __PROJECT_H__
#define __PROJECT_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#include <gtk/gtk.h>
#include "main.h"

#ifdef WANT_PROJECT

typedef struct {
	unsigned	_rev;		/* file format version (internal use) */
	char *		name;		/* name of project */
	unsigned	numfiles;	/* number of files in project */
	unsigned	version;	/* project version number */
	char *		path;		/* path to project */
	GSList *	files;		/* files in project */
} prj_t;

#define prj_current(d)	(prj_t *)((d)->prj)

extern void prj_close_cb(GtkWidget *wgt, gpointer cbdata);
extern void prj_open_cb(GtkWidget *wgt, gpointer cbdata);
extern void prj_close_all_cb(GtkWidget *wgt, gpointer cbdata);
extern void prj_list_show(GtkWidget *wgt, gpointer cbdata);
extern void prj_free_all(win_t *w);

#else

#define prj_current(d)
#define prj_close_cb(wgt, cbd)
#define prj_open_cb(wgt, cbd)
#define prj_close_all_cb(wgt, cbd)
#define prj_list_show(wgt, cbd)
#define prj_free_all(w)

#endif	/* WANT_PROJECT */

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif	/* __PROJECT_H__ */
