/* vi:set ts=8 sts=0 sw=8:
 * $Id: main.h,v 1.45 2000/05/10 15:30:04 kahn Exp kahn $
 *
 * Copyright (C) 1998 Andy C. Kahn
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef __MAIN_H__
#define __MAIN_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include <stdio.h>
#include <stdarg.h>
#include <assert.h>
#include "../config.h"
#include <gtk/gtk.h>
#ifdef WANT_GNOME
#include <config.h>
#include <gnome.h>
#endif
#ifdef USE_GTKHTML
#include <gtkhtml/gtkhtml.h>
#endif
#ifdef USE_GTKXMHTML
#include <gtk-xmhtml/gtk-xmhtml.h>
#endif
#ifdef USE_LIBGLADE
#include <glade/glade.h>
#endif
#include "debug.h"


#ifdef APP_GNP
# define APP_NAME	"gnotepad+"
# define APP_VERSION	VERSION
# define APP_DATE	"June-07-2000"
# define APP_URL	"http://gnotepad.sourceforge.net"
#endif

#define UNTITLED	gettext("Untitled")
#define UNKNOWN		gettext("Unknown")
#define WELCOME_MSG	gettext("Welcome to ")
#define NULL_CALLBACK	NULL
#define MAX_RGB_STR	32

#ifdef MAXPATH
# undef MAXPATH
#endif
#define MAXPATH		255

#ifndef ESUCCESS		/* hmm, this is missing on my Linux box */
# define ESUCCESS        0
#endif

#ifdef USE_REGEX
# undef USE_REGEX
#endif
#if defined(HAVE_REGCOMP) && defined(HAVE_REGERROR) && \
    defined(HAVE_REGEXEC) && defined(HAVE_REGFREE) && defined(HAVE_REGEX_H)
# define USE_REGEX
#endif

typedef unsigned char bool_t;
typedef char byte;
typedef unsigned char ubyte;

typedef enum { FnumCol = 0, FsizeCol, FnameCol } clist_col_t;

#ifndef GTK_HAVE_FEATURES_1_1_0
extern char *g_vsprintf(const char *fmt, va_list *args, va_list *args2);
#define gtk_button_set_relief(button, relief)
#define gtk_container_set_border_width(w, v)	gtk_container_border_width(w, v)
#define gtk_editable_set_position(e, p)		(e)->current_pos = (p)
#define gtk_editable_get_position(e)		(e)->current_pos
#define gtk_notebook_get_current_page(nb)	gtk_notebook_current_page(nb)
#define gtk_editable_copy_clipboard(e)		\
		gtk_editable_copy_clipboard((e), GDK_CURRENT_TIME)
#define gtk_editable_cut_clipboard(e)		\
		gtk_editable_cut_clipboard((e), GDK_CURRENT_TIME)
#define gtk_editable_paste_clipboard(e)		\
		gtk_editable_paste_clipboard((e), GDK_CURRENT_TIME)
#define gtk_window_set_position(gw, pos)	gtk_window_position((gw), (pos))
#define gtk_toggle_button_set_active(t, f)	(t)->active = (f)
#define gtk_toolbar_set_button_relief(tb, relief)
#define gtk_window_set_default_size(gw, w, h)	\
		gtk_widget_set_usize(GTK_WIDGET(gw), w, h)
#endif

#ifdef USE_GNOME
#include <gnome.h>
#else
#define GNOME_STOCK_BUTTON_OK		NULL
#define GNOME_STOCK_BUTTON_CANCEL	NULL
#define GNOME_STOCK_BUTTON_YES		NULL
#define GNOME_STOCK_BUTTON_NO		NULL
#define GNOME_STOCK_BUTTON_CLOSE	NULL
#define GNOME_STOCK_BUTTON_APPLY	NULL
#define GNOME_STOCK_BUTTON_HELP		NULL
#define GNOME_STOCK_BUTTON_NEXT		NULL
#define GNOME_STOCK_BUTTON_PREV		NULL
#define GNOME_STOCK_BUTTON_UP		NULL
#define GNOME_STOCK_BUTTON_DOWN		NULL
#define GNOME_STOCK_BUTTON_FONT		NULL

#define GNOME_STOCK_PIXMAP_NEW		NULL
#define GNOME_STOCK_PIXMAP_OPEN		NULL
#define GNOME_STOCK_PIXMAP_CLOSE	NULL
#define GNOME_STOCK_PIXMAP_REVERT	NULL
#define GNOME_STOCK_PIXMAP_SAVE		NULL
#define GNOME_STOCK_PIXMAP_SAVE_AS	NULL
#define GNOME_STOCK_PIXMAP_CUT		NULL
#define GNOME_STOCK_PIXMAP_COPY		NULL
#define GNOME_STOCK_PIXMAP_PASTE	NULL
#define GNOME_STOCK_PIXMAP_CLEAR	NULL
#define GNOME_STOCK_PIXMAP_PROPERTIES	NULL
#define GNOME_STOCK_PIXMAP_PREFERENCES	NULL
#define GNOME_STOCK_PIXMAP_HELP		NULL
#define GNOME_STOCK_PIXMAP_SCORES	NULL
#define GNOME_STOCK_PIXMAP_PRINT	NULL
#define GNOME_STOCK_PIXMAP_SEARCH	NULL
#define GNOME_STOCK_PIXMAP_SRCHRPL	NULL
#define GNOME_STOCK_PIXMAP_BACK		NULL
#define GNOME_STOCK_PIXMAP_FORWARD	NULL
#define GNOME_STOCK_PIXMAP_FIRST	NULL
#define GNOME_STOCK_PIXMAP_LAST		NULL
#define GNOME_STOCK_PIXMAP_HOME		NULL
#define GNOME_STOCK_PIXMAP_STOP		NULL
#define GNOME_STOCK_PIXMAP_REFRESH	NULL
#define GNOME_STOCK_PIXMAP_UNDO		NULL
#define GNOME_STOCK_PIXMAP_REDO		NULL
#define GNOME_STOCK_PIXMAP_TIMER	NULL
#define GNOME_STOCK_PIXMAP_TIMER_STOP	NULL
#define GNOME_STOCK_PIXMAP_MAIL		NULL
#define GNOME_STOCK_PIXMAP_MAIL_RCV	NULL
#define GNOME_STOCK_PIXMAP_MAIL_SND	NULL
#define GNOME_STOCK_PIXMAP_MAIL_RPL	NULL
#define GNOME_STOCK_PIXMAP_MAIL_FWD	NULL
#define GNOME_STOCK_PIXMAP_MAIL_NEW	NULL
#define GNOME_STOCK_PIXMAP_TRASH	NULL
#define GNOME_STOCK_PIXMAP_TRASH_FULL	NULL
#define GNOME_STOCK_PIXMAP_UNDELETE	NULL
#define GNOME_STOCK_PIXMAP_SPELLCHECK	NULL
#define GNOME_STOCK_PIXMAP_MIC		NULL
#define GNOME_STOCK_PIXMAP_LINE_IN	NULL
#define GNOME_STOCK_PIXMAP_CDROM	NULL
#define GNOME_STOCK_PIXMAP_VOLUME	NULL
#define GNOME_STOCK_PIXMAP_MIDI		NULL
#define GNOME_STOCK_PIXMAP_BOOK_RED	NULL
#define GNOME_STOCK_PIXMAP_BOOK_GREEN	NULL
#define GNOME_STOCK_PIXMAP_BOOK_BLUE	NULL
#define GNOME_STOCK_PIXMAP_BOOK_YELLOW	NULL
#define GNOME_STOCK_PIXMAP_BOOK_OPEN	NULL
#define GNOME_STOCK_PIXMAP_ABOUT	NULL
#define GNOME_STOCK_PIXMAP_QUIT		NULL
#define GNOME_STOCK_PIXMAP_MULTIPLE	NULL
#define GNOME_STOCK_PIXMAP_NOT		NULL
#define GNOME_STOCK_PIXMAP_CONVERT	NULL
#define GNOME_STOCK_PIXMAP_JUMP_TO	NULL
#define GNOME_STOCK_PIXMAP_UP		NULL
#define GNOME_STOCK_PIXMAP_DOWN		NULL
#define GNOME_STOCK_PIXMAP_TOP		NULL
#define GNOME_STOCK_PIXMAP_BOTTOM	NULL

#endif	/* USE_GNOME */

#ifndef USE_LIBGLADE
# define glade_gnome_init()
#endif


#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif	/* __MAIN_H__ */
