/* vi:set ts=8 sts=0 sw=8:
 * $Id: htmlview.h,v 1.6 1999/12/11 03:13:54 kahn Exp kahn $
 *
 * Copyright (C) 1998 Andy C. Kahn
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef __HTMLVIEW_H__
#define __HTMLVIEW_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include <stdio.h>
#include "main.h"
#include "doc.h"

typedef enum {
	HtmlViewXmHtml,
	HtmlViewGtkHtml,
	HtmlViewXmHtmlDoc,
	HtmlViewGtkHtmlDoc,
	HtmlViewBrowser
} htmlview_t;


extern void	html_view_cb(GtkWidget *wgt, gpointer, guint cbaction);
#ifdef USE_GNOME
extern void	html_view_xmhtml_win_cb(GtkWidget *wgt, gpointer cbdata);
extern void	html_view_gtkhtml_win_cb(GtkWidget *wgt, gpointer cbdata);
extern void	html_view_xmhtml_doc_cb(GtkWidget *wgt, gpointer cbdata);
extern void	html_view_gtkhtml_doc_cb(GtkWidget *wgt, gpointer cbdata);
extern void	html_view_browser_cb(GtkWidget *wgt, gpointer cbdata);
#endif
#ifdef USE_GTKHTML
extern void html_view_url_requested(GtkHTML *html, const char *url,
				    GtkHTMLStreamHandle handle, gpointer);
#endif

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif	/* __HTMLVIEW_H__ */
