// -*- c++ -*-

//  Gnomoradio - roboradio/song-rainbow.h
//  Copyright (C) 2003  Jim Garrison
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef __ROBORADIO_SONG_RAINBOW_H
#define __ROBORADIO_SONG_RAINBOW_H

#include <set>
#include <libxml++/libxml++.h>
#include <glibmm.h>
#include "roboradio/song-local.h"
#include "rainbow/hub-client.h"
#include "rainbow/license.h"

namespace Roboradio
{
	class SongRainbow : public SongLocal
	{
	public:
		SongRainbow (const Glib::ustring &loc);
		virtual ~SongRainbow ();

		void obtain_available_info ();
	        bool importable ();
		void import ();
		void uncache ();
		Glib::ustring get_filename () const;

	private:
		void download_resource ();
		void create_hub_resource ();
		void downloading_callback (unsigned int progress);
		void download_done_callback (bool success);
		void found_info_callback (bool success);
		void file_deleted_callback ();
		void on_song_rdf_downloaded (xmlpp::Element *song,
					     Rainbow::ref_ptr<Rainbow::RdfResource> rdf);
		void on_album_rdf_downloaded (xmlpp::Element *album,
					      Rainbow::ref_ptr<Rainbow::RdfResource> rdf);
		void on_artist_rdf_downloaded (xmlpp::Element *artist,
					       Rainbow::ref_ptr<Rainbow::RdfResource> rdf);
		void on_audiofiles_determined ();

		static void uncache_as_appropriate (size_t kb);

		Rainbow::ref_ptr<Rainbow::Resource> resource;
		std::set<Glib::ustring> audiofiles;

		bool import_once_info_is_obtained;
		int fetching_info;

		static bool initialized;

		friend class State;
	};
}

#endif
