//  Gnomoradio - roboradio/player.cc
//  Copyright (C) 2003  Jim Garrison
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version)
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "player.h"
#include "song-list-radio.h"

using namespace std;
using namespace SigC;
using namespace Roboradio;

void Roboradio::Player::play (const ref_ptr<SongList> &list,
			      SongList::iterator song)
{
	if (&*current_song_list)
		current_song_list->transfer_play(list, song);
	else
		list->play(song);

	current_song_list_done_connection.disconnect();
	current_song_list_shuffle_connection.disconnect();
	current_song_list_changed_connection.disconnect();

	current_song_list = list;

	SongListRadio *slr = dynamic_cast<SongListRadio*>(&*list);
	current_song_list_done_connection = list->signal_done.connect(slot(*this, &Player::done));
	current_song_list_shuffle_connection = list->signal_shuffle_changed.connect(bind(slot(*this, &Player::on_shuffle_changed), (slr ? slr->get_source() : list)));
	current_song_list_changed_connection = list->signal_current_song_changed.connect(signal_song_changed);

	signal_state_changed();
}

void Roboradio::Player::play (const ref_ptr<SongList> &list)
{
	if (list->begin() != list->end())
		play(list, list->begin());
}

void Roboradio::Player::stop ()
{
	if (&*current_song_list) {
		current_song_list->stop();
		done();
	}
}

void Roboradio::Player::prev ()
{
	if (&*current_song_list)
		current_song_list->prev();
}

void Roboradio::Player::next ()
{
	if (&*current_song_list)
		current_song_list->next();
}

void Roboradio::Player::done ()
{
	current_song_list_done_connection.disconnect();
	current_song_list_shuffle_connection.disconnect();
	current_song_list_changed_connection.disconnect();
	current_song_list = ref_ptr<SongList>();
	signal_state_changed();
}

void Roboradio::Player::on_shuffle_changed (bool s, ref_ptr<SongList> sl)
{
	current_song_list_done_connection.disconnect();
	current_song_list_changed_connection.disconnect();

	if (s)
		current_song_list = sl->get_shuffle_list();
	else
		current_song_list = sl;

	current_song_list_done_connection = current_song_list->signal_done.connect(slot(*this, &Player::done));
	current_song_list_changed_connection = current_song_list->signal_current_song_changed.connect(signal_song_changed);

	signal_state_changed();
}

void Roboradio::Player::pause ()
{
	if (&*get_song()) {
		if (get_song()->get_playback() == PAUSE)
			get_song()->set_playback(PLAY);
		else
			get_song()->set_playback(PAUSE);
		signal_state_changed();
	}
}

bool Roboradio::Player::get_paused ()
{
	return (&*get_song() && get_song()->get_playback() == PAUSE);
}
