//  Gnomoradio - rainbow/rainbow-get.cc
//  Copyright (C) 2003  Jim Garrison
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "rainbow/init.h"
#include <iostream>

using namespace std;
using namespace Rainbow;

static int failures = 0;
static int remaining = 0;

static void on_download_done (bool success)
{
	if (!success)
		failures++;

	if (--remaining == 0)
		exit(failures);
}

int main (int argc, char *argv[])
{
	if (argc < 2)
		return 1;

	Rainbow::Init rainbow;

	for (int i = 1; i < argc; ++i) {
		ref_ptr<Resource> r = rainbow.hub().create(argv[i]);
		if (!r->downloaded()) {
			++remaining;
			r->signal_download_done.connect(SigC::slot(&on_download_done));
			rainbow.hub().prepare_resource(r);
		}
	}

	if (remaining) {
		Glib::RefPtr<Glib::MainLoop> ml = Glib::MainLoop::create();
		ml->run();
	}

	return 0;
}
