//  Gnomoradio - gnomoradio/prefs-box.cc
//  Copyright (C) 2003  Matt Gerginski, Jim Garrison
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "prefs-box.h"

using namespace Gtk;
using namespace Wraporadio;
using namespace Glib;
using namespace std;

Gnomoradio::PrefsBoxBase::PrefsBoxBase ()
	: rainbow_checkbutton(_("Enable Rainbow")),
	  rainbow_hub_label(_("Rainbow Hub")),
	  privacy_checkbutton(_("Conserve Privacy")),
	  plan_ahead_adj(0, 0, 4320),
	  plan_ahead_time(plan_ahead_adj, 1, 0)
{
	State state = wr.get_state();

	/* radio list plan ahead time */
	plan_ahead_adj.set_value(state.get_plan_ahead_time());

	/* rainbow stuff */
	rainbow_hub.set_text(state.get_rainbow_hub());
	rainbow_checkbutton.set_active(state.get_rainbow_enabled());
	privacy_checkbutton.set_active(state.get_conserve_privacy());

	bool enabled = rainbow_checkbutton.get_active();

	rainbow_hub.set_sensitive(enabled);
	rainbow_hub_label.set_sensitive(enabled);
	privacy_checkbutton.set_sensitive(enabled);

	rainbow_checkbutton.signal_toggled().connect(SigC::slot(*this, &PrefsBoxBase::on_rainbow_checkbutton_toggled));
	privacy_checkbutton.signal_toggled().connect(SigC::slot(*this, &PrefsBoxBase::on_rainbow_privacy_checkbutton_toggled));
}

Gnomoradio::PrefsBoxBase::~PrefsBoxBase ()
{
	/* save values for options that aren't saved as they change */
	wr.get_state().set_rainbow_hub(rainbow_hub.get_text());
	wr.get_state().set_plan_ahead_time(Time(plan_ahead_time.get_value()));
}

Gtk::Widget *Gnomoradio::PrefsBoxBase::rainbow_setup ()
{
	Table *rainbow_table = new Table(3, 1, false);

	HBox *rainbow_hub_hbox = manage(new HBox());
	rainbow_hub_hbox->pack_start(rainbow_hub_label, false, false);
	rainbow_hub_hbox->pack_start(rainbow_hub, false, false, 5);

	rainbow_table->attach(rainbow_checkbutton, 0, 1, 0, 1, EXPAND | FILL, SHRINK);
	rainbow_table->attach(*rainbow_hub_hbox, 0, 1, 1, 2, EXPAND | FILL, SHRINK, 20, 0);
	rainbow_table->attach(privacy_checkbutton, 0, 1, 2, 3, EXPAND | FILL, SHRINK, 20, 0);

	rainbow_table->set_row_spacings(8);
	rainbow_table->set_col_spacings(8);

	return rainbow_table;
}

void Gnomoradio::PrefsBoxBase::on_rainbow_checkbutton_toggled ()
{
	bool enabled = rainbow_checkbutton.get_active();

	rainbow_hub.set_sensitive(enabled);
	rainbow_hub_label.set_sensitive(enabled);
	privacy_checkbutton.set_sensitive(enabled);

	wr.get_state().set_rainbow_enabled(enabled);
}

void Gnomoradio::PrefsBoxBase::on_rainbow_privacy_checkbutton_toggled ()
{
	wr.get_state().set_conserve_privacy(privacy_checkbutton.get_active());
}

Gnomoradio::PrefsBox::PrefsBox ()
	: close_button(_("Close"))
{
	/* set some values to make window look nice */
	set_title(_("Preferences"));
	set_resizable(false);
	set_border_width(10);

	/*connect signals for closing the prefs box */
	close_button.signal_clicked().connect(SigC::slot(*this, &Gnomoradio::PrefsBox::on_close_clicked));

	/* Window and Main Table */
	Table *table = manage(new Table(3, 1, FALSE)); // Main table
        
	VBox *window_vbox = manage(new VBox(false, 8));
	add(*window_vbox);

	HSeparator *sep = manage(new HSeparator());

	window_vbox->pack_start(*table, false, false);
	window_vbox->pack_start(*sep, false, false);
	window_vbox->pack_start(close_button, false, false);

	/* Radio List HBox */
	HBox *radio_list_hbox = manage(new HBox(false, 4));
	Label *front_label = manage(new Label(_("In Radio Playlists, plan ahead")));
	Label *end_label = manage(new Label(_("minutes.")));
	
	radio_list_hbox->pack_start(*front_label, false, false);
	radio_list_hbox->pack_start(plan_ahead_time, false, false);
	radio_list_hbox->pack_start(*end_label, false, false);

	/* Rainbow Table */
	Widget *rainbow_table = manage(rainbow_setup());

	table->attach(song_paths, 0, 1, 0, 1);
	table->attach(*radio_list_hbox, 0, 1, 1, 2, EXPAND | FILL, SHRINK, 0, 20);
	table->attach(*rainbow_table, 0, 1, 2, 3);

	signal_hide().connect(SigC::slot(*this, &Gnomoradio::PrefsBox::on_hide_event));

	show_all();
}

Gnomoradio::PrefsBox::~PrefsBox ()
{
}

void Gnomoradio::PrefsBox::on_close_clicked ()
{
	hide();
}

void Gnomoradio::PrefsBox::on_hide_event ()
{
	delete this;
}
