/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */
/* broadcast-dialog.cpp
 *
 * Copyright (C) 2005 Takuo KITAME.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 2 of the GNU General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 *
 * Author: Takuo KITAME.
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "servmgr.h"

#include "utils.h"
#include "broadcast-dialog.h"

#define GLADE_FILE_NAME "gnome-peercast.glade"

static void
dialog_response_cb (GtkDialog *dlg, gint id, gpointer data)
{
	BroadcastDialog *bd = (BroadcastDialog *)data;

	switch (id) {
	case GTK_RESPONSE_OK:
		if ( ! bd->createRelay ())
			return;
		/* FIXME: alart should be poped up*/
		break;
	case GTK_RESPONSE_CANCEL:
		break;
	}

	gtk_widget_destroy (GTK_WIDGET (dlg));
	delete bd;
}

GtkWidget *
BroadcastDialog::getWidget (const gchar *name)
{
	return glade_xml_get_widget (xml, name);
}

gboolean
BroadcastDialog::createRelay (void)
{
	GtkWidget *w;
	ChanInfo info;
	String surl;
	const gchar *tmp;
	gint i;

	/* Source URL */
	w = getWidget ("entry_source");
	tmp = gtk_entry_get_text (GTK_ENTRY (w));
	if (strlen (tmp) == 0)
		return FALSE;
	surl.set (tmp, String::T_ESC);
	surl.convertTo (String::T_UNICODE);

	/* Name */
	w = getWidget ("entry_name");
	tmp = gtk_entry_get_text (GTK_ENTRY (w));
	if (strlen (tmp) == 0)
		return FALSE;
	info.name.set (tmp, String::T_ESC);
	info.name.convertTo (String::T_UNICODE);

	/* Genre */
	w = getWidget ("entry_genre");
	tmp = gtk_entry_get_text (GTK_ENTRY (w));
	info.genre.set (tmp,String::T_ESC);
	info.genre.convertTo (String::T_UNICODE);

	/* Description */
	w = getWidget ("entry_desc");
	tmp = gtk_entry_get_text (GTK_ENTRY (w));
	info.desc.set (tmp,String::T_ESC);
	info.desc.convertTo (String::T_UNICODE);

	/* Contact URL */
	w = getWidget ("entry_curl");
	tmp = gtk_entry_get_text (GTK_ENTRY (w));
	info.url.set (tmp,String::T_ESC);
	info.url.convertTo (String::T_UNICODE);

	/* Bitrate */
	w = getWidget ("entry_rate");
	tmp = gtk_entry_get_text (GTK_ENTRY (w));
	i = strtol (tmp, NULL, 10);
	info.bitrate = i;

	/* Type */
	w = getWidget ("combo_type");
	tmp = gtk_combo_box_get_active_text (GTK_COMBO_BOX (w));
	if (strlen (tmp) == 0)
		return FALSE;
	info.contentType = ChanInfo::getTypeFromStr (tmp);

	Channel *c = chanMgr->createChannel (info, NULL);
	if (c)
		c->startURL (surl.cstr());

	return TRUE;
}

BroadcastDialog::BroadcastDialog (GtkWindow *window)
{
	GtkWidget *dialog;

	debug_print (1, "New object: BroadcastDialog");

	parent = window;
	xml = load_glade_xml (GLADE_FILE_NAME, "broadcast_dlg");
	dialog = getWidget ("broadcast_dlg");
	gtk_widget_hide (dialog);
	gtk_window_set_transient_for (GTK_WINDOW (dialog), parent);

	glade_xml_signal_connect_data (xml, "broadcast_dlg_response",
				       G_CALLBACK (dialog_response_cb), this);
	gtk_combo_box_set_active (GTK_COMBO_BOX (getWidget ("combo_type")), 0);

	gtk_widget_show (dialog);
}

