/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */
/* main.cpp
 *
 * Copyright (C) 2005 Takuo KITAME.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 2 of the GNU General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 *
 * Author: Takuo KITAME.
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdarg.h>
#include <stdio.h>
#include "channel.h"
#include "servent.h"
#include "servmgr.h"
#include "unix/usys.h"
#include <sys/types.h>
#include <unistd.h>
#include <signal.h>
#include <stdlib.h>
#include "peercast.h"

#include <gnome.h>
#include <glade/glade.h>
#include <gconf/gconf-client.h>

#include "utils.h"
#include "channel-list.h"
#include "connection-list.h"
#include "callbacks.h"
#include "logview.h"
#include "gnome-peercast.h"

// ----------------------------------
String iniFileName;
bool quit=false;

extern gint debug_level;

//--------------------------------------------
class MyPeercastInst : public PeercastInstance
{
public:
	virtual Sys * APICALL createSys()
	{
		return new USys();
	}
};

// ----------------------------------
void setSettingsUI(){}
// ----------------------------------
void showConnections(){}
// ----------------------------------
void PRINTLOG(LogBuffer::TYPE type, const char *fmt,va_list ap)
{
}

// ----------------------------------
void sigProc(int sig)
{
	switch (sig)
	{
	case 2:
		if (!quit)
			LOG_DEBUG("Received QUIT signal");
		quit=true;
		break;
	}
}

static void
client_die_cb(GnomeClient *client, gpointer data)
{
	g_print("program dead\n");
}

static gboolean
handle_cmdline_args (int argc, gchar **argv)
{
	for (gint i = 1; i < argc; i++) {
		parse_peercast_url(argv[i], false);
	}
	return FALSE;
}

// ----------------------------------
int
main (gint argc, gchar* argv[])
{
	GnomeProgram *program;
	GError *error = NULL;
	GnomeClient *client;
	GnomePeercastApp *myapp;
	gboolean no_gui = FALSE;
	const gchar **sarray = NULL;
	GOptionContext *ctx;
	GOptionEntry entries[] = {
		{ "no-gui", 0, 0, G_OPTION_ARG_NONE, &no_gui, N_("run without GUI"), NULL },
		{ NULL }
	};


	if (g_getenv ("GNOME_PEERCAST_DEBUG"))
			debug_level = atoi (g_getenv ("GNOME_PEERCAST_DEBUG"));

	debug_print (1, "DEBUG_LEVEL = %d", debug_level);

#ifdef ENABLE_NLS
	bindtextdomain (GETTEXT_PACKAGE, GNOME_LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
#endif

	ctx = g_option_context_new ("- GNOME Peercast front end");
	g_option_context_set_help_enabled (ctx, FALSE);
	g_option_context_set_ignore_unknown_options (ctx, TRUE);
	g_option_context_add_main_entries (ctx, entries, GETTEXT_PACKAGE);
	g_option_context_add_group (ctx, gtk_get_option_group (TRUE));
	g_assert (g_option_context_parse (ctx, &argc, &argv, &error) != FALSE);
	g_option_context_free (ctx);

	if (no_gui)
		g_warning ("NO GUI MODE");

	if (g_file_test ("peercast.ini", G_FILE_TEST_EXISTS))
		iniFileName.set("peercast.ini");
	else {
		gchar p[4096];
		g_snprintf(p, sizeof(p), "%s/.peercast.ini", g_get_home_dir());
		iniFileName.set(p);
	}

	peercastInst = new MyPeercastInst();
	if (! no_gui) {
		program = gnome_program_init (PACKAGE,
					      "0.1212g0.1",
					      LIBGNOMEUI_MODULE,
					      argc, argv,
					      GNOME_PARAM_HUMAN_READABLE_NAME, _("GNOME PeerCast"),
					      NULL);

		gnome_window_icon_set_default_from_file (ICON_DIR"/peercast.png");
		client = gnome_master_client ();
		g_signal_connect (client, "die", G_CALLBACK (client_die_cb), NULL);
	}

	myapp = new GnomePeercastApp();
	if (! no_gui)
		myapp->guiInit ();

	peercastApp = (PeercastApplication *)myapp;
	peercastInst->init();

	myapp->gconfInit ();
	myapp->infoInit ();

	handle_cmdline_args (argc, argv);

	gtk_main();

	/* clean up */
	peercastInst->saveSettings ();
	peercastInst->quit ();

	return 0;
}
