#!/usr/bin/python

# Hearts - stock_ai.py
# Copyright 2006 Sander Marechal
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

# This is a simple stock AI used for the standard players and the "hint" feature. It's not too
# smart overall, but it works.

from definitions import *
from player import Player
from player_api import *

class StockAI(Player):
	"""This is the default AI for gnome-hearts"""
	
	def select_cards(self):
		"""Return a list of three cards hat will be passed to an opponent"""
		result = []
		
		def select(card):
			result.append(card)
			self.hand.remove(card)
		
		# First pass on the high spades	
		if (spades, queen)    in self.hand: select((spades, queen))
		if (spades, king)     in self.hand: select((spades, king))
		if (spades, ace_high) in self.hand: select((spades, ace_high))
		
		# Pass off the other cards
		while len(result) < 3:
			clubs_list    = filter(f_clubs, self.hand)
			diamonds_list = filter(f_diamonds, self.hand)
			hearts_list   = filter(f_hearts, self.hand)
			
			# If we can clear a suit with one card then do so, else pick a hearts or a high card
			if len(clubs_list) == 1:
				select(clubs_list[0])
			elif len(diamonds_list) == 1:
				select(diamonds_list[0])
			elif len(hearts_list):
				hearts_list.sort(s_rank, reverse=True)
				select(hearts_list[0])
			else:
				self.hand.sort(s_rank, reverse=True)
				select(self.hand[0])
		return result
	
	def play_card(self):
		"""Play a card"""
		valid_cards = filter(self.f_valid, self.hand)
		
		# Open with the lowest valid card
		if self.trick.num_played == 0:
			valid_cards.sort(s_rank)
			return valid_cards[0]
		
		# Someone has already played. If the score is zero, it's not a point card
		if trick_get_score == 0:
			# If we have a trump suit, take it with the highest card
			if have_suit(self.hand, self.trick.trump):
				valid_cards.sort(rank, reverse=True)
				# Make sure we're not giving ourself 13 points
				if valid_cards[0] == (spades, queen) and len(valid_cards) > 0:
					return valid_cards[1]
				return valid_cards[0]
			# We don't have a trump. Dump a point card
			valid_cards,sort(s_points, reverse=True)
			return valid_cards[0]
		
		# There are point cards on the trick. Play the highest card that doesn't take the trick
		high_card = self.trick.get_highest_card()
		valid_cards.sort(s_rank, reverse=True)
		for card in valid_cards:
			if card[0] != high_card[0] or card[1] < high_card[1]: return card
		
		# We are forced to take the trick. Play highest card if we're the last player
		if self.trick.num_played == 3: return valid_cards[0]
		
		# Play low. Someone may beat us yet
		valid_cards.sort(s_rank)
		return valid_cards[0]	
