/*
 *  Hearts - hearts.h
 *  Copyright 2006 Sander Marechal
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#ifndef HEARTS_H
#define HEARTS_H

/* gettext support */
#include "gettext.h"

/* headers */
#include <dirent.h>
#include <gnome.h>
#include <glade/glade.h>
#include "cards.h"
#include "player.h"

/* the game states */
enum
{
	GAME_SELECT_CARDS	= 0,
	GAME_PASS_CARDS		= 1,
	GAME_RECIEVE_CARDS	= 2,
	GAME_PLAY			= 3,
	GAME_ROUND_END		= 4,
	GAME_END			= 5
};

/* the game rules */
typedef struct _GameRules
{
	gint	 ruleset;
	gboolean clubs_lead;
	gboolean hearts_break;
	gboolean no_blood;
	GString  *north_ai;
	GString  *east_ai;
	GString  *west_ai;
} GameRules;

/* the GIU */
extern GladeXML *xml;

/* the background */
typedef struct _GameBackground
{
	gboolean  tiled;
	Preimage  *image;
	GdkPixmap *tile;
	GdkPixbuf *buffer;
	GdkGC	  *gc;
} GameBackground;
extern GameBackground background;

/* rendering globals */
extern GdkPixmap 	*backbuffer; 
extern GdkGC 		*backbuffer_gc;
extern CardsImage 	*cards_image;

/* the game's globals */
extern GameRules 	game_rules;
extern Trick 	 	game_trick;
extern gint 	 	game_state;
extern gint 	 	game_pass;
extern gint 	 	game_trick_winner;
extern gboolean  	game_hearts_broken;
extern CardsDeck 	*game_deck;
extern GList	 	*game_score_labels;
extern GList	 	*game_ai_scripts;
extern GHashTable	*game_card_styles;
extern GString	 	*game_card_style;
extern GString		*game_background;
extern gboolean		game_background_tiled;
extern lua_State	*game_hint_lua_state;

/* the players */
extern Player 	*player[4];
extern gint 	user;

/* forward declarations */
GdkPixmap* get_pixmap (const char *filename);

void 	background_new();
void 	background_load(gchar* path);
void 	background_set_size(gint width, gint height);
void 	background_set_tiled(gboolean tiled);
void	background_render(GdkPixmap *target, gint x, gint y, gint width, gint height);
void 	background_free();

void	 game_new (void);
void	 game_new_round (void);
void	 game_restart_round (void);
void 	 game_open_round (void);
gboolean game_end_test (void);
gboolean game_pass_cards (GtkWidget *widget);
gint 	 game_select_cards (GtkWidget *widget);
void 	 game_score_publish (lua_State *state);
gboolean game_is_valid_card (Card *card, CardsHand *hand, Trick *trick);
gchar*	 game_get_hint(void);
void	 game_set_status(gchar *message);

void draw_playingarea();
void card_style_add(gpointer key, gpointer value, gpointer box);
int  main (int argc, char *argv[]);

#endif
