/*
 * gnome-gmail-notifier: the gnome gmail notifier.
 * Copyright (C) 2007 Bradley A. Worley.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the
 * 
 *     Free Software Foundation, Inc.
 *     59 Temple Place, Suite 330
 *     Boston, MA 02111-1307 USA
 */

/*
 * ensure this is a once-only header.
 */
#ifndef __GNOME_GMAIL_NOTIFIER_UTIL_H__
#define __GNOME_GMAIL_NOTIFIER_UTIL_H__

/*
 * our header is just beginning.
 */
G_BEGIN_DECLS

/*
 * default text encoding style.
 */
#define GGN_UTIL_ENCODING       "UTF-8"

/*
 * default pixmap file title strings.
 */
#define GGN_PIXMAP_NORMAL       "normal"
#define GGN_PIXMAP_ERROR        "error"
#define GGN_PIXMAP_MESSAGE      "new"
#define GGN_PIXMAP_CHECKING     "wait"
#define GGN_PIXMAP_WARNING      "warn"

/*
 * default glade xml file title strings.
 */
#define GGN_GLADE_MENU          "menu"
#define GGN_GLADE_PREFS         "prefs"
#define GGN_GLADE_ABOUT         "about"
#define GGN_GLADE_EDIT          "edit"

/*
 * default gconf strings to utilize.
 */
#define GGN_GCONF_BROWSER           "/desktop/gnome/url-handlers/http/command"
#define GGN_GCONF_EMAILER           "/desktop/gnome/url-handlers/mailto/command"
#define GGN_GCONF_PROXY_USE         "/system/http_proxy/use_http_proxy"
#define GGN_GCONF_PROXY_HOST        "/system/http_proxy/host"
#define GGN_GCONF_PROXY_PORT        "/system/http_proxy/port"
#define GGN_GCONF_PROXY_SSL_HOST    "/system/proxy/secure_host"
#define GGN_GCONF_PROXY_SSL_PORT    "/system/proxy/secure_port"

/*
 * String-to-Boolean exchange functions.
 */
gchar* ggn_btostr (gboolean value);
gboolean ggn_strtob (gchar* value);

/*
 * filename functions.
 */
gchar* ggn_pixmap_file (gchar* title);
gchar* ggn_glade_file (gchar* title);

/*
 * interconnectivity function.
 */
void ggn_client_execute (const gchar* link);

/*
 * our header is at its end.
 */
G_END_DECLS

#endif /* __GNOME_GMAIL_NOTIFIER_UTIL_H__ */

