/* playstation-game-factory.c generated by valac 0.35.5.22-e5360, the Vala compiler
 * generated from playstation-game-factory.vala, do not modify */

/* This file is part of GNOME Games. License: GPL-3.0+.*/

#include <glib.h>
#include <glib-object.h>
#include <libgnome-games.h>
#include <stdlib.h>
#include <string.h>
#include <libtracker-sparql/tracker-sparql.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>


#define GAMES_TYPE_PLAY_STATION_GAME_FACTORY (games_play_station_game_factory_get_type ())
#define GAMES_PLAY_STATION_GAME_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_PLAY_STATION_GAME_FACTORY, GamesPlayStationGameFactory))
#define GAMES_PLAY_STATION_GAME_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_PLAY_STATION_GAME_FACTORY, GamesPlayStationGameFactoryClass))
#define GAMES_IS_PLAY_STATION_GAME_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_PLAY_STATION_GAME_FACTORY))
#define GAMES_IS_PLAY_STATION_GAME_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_PLAY_STATION_GAME_FACTORY))
#define GAMES_PLAY_STATION_GAME_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_PLAY_STATION_GAME_FACTORY, GamesPlayStationGameFactoryClass))

typedef struct _GamesPlayStationGameFactory GamesPlayStationGameFactory;
typedef struct _GamesPlayStationGameFactoryClass GamesPlayStationGameFactoryClass;
typedef struct _GamesPlayStationGameFactoryPrivate GamesPlayStationGameFactoryPrivate;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block1Data Block1Data;
typedef struct _GamesPlayStationGameFactoryForeachGameData GamesPlayStationGameFactoryForeachGameData;

#define GAMES_TYPE_PLAY_STATION_HEADER (games_play_station_header_get_type ())
#define GAMES_PLAY_STATION_HEADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_PLAY_STATION_HEADER, GamesPlayStationHeader))
#define GAMES_PLAY_STATION_HEADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_PLAY_STATION_HEADER, GamesPlayStationHeaderClass))
#define GAMES_IS_PLAY_STATION_HEADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_PLAY_STATION_HEADER))
#define GAMES_IS_PLAY_STATION_HEADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_PLAY_STATION_HEADER))
#define GAMES_PLAY_STATION_HEADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_PLAY_STATION_HEADER, GamesPlayStationHeaderClass))

typedef struct _GamesPlayStationHeader GamesPlayStationHeader;
typedef struct _GamesPlayStationHeaderClass GamesPlayStationHeaderClass;
typedef struct _Block2Data Block2Data;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))

#define GAMES_TYPE_PLAY_STATION_UID (games_play_station_uid_get_type ())
#define GAMES_PLAY_STATION_UID(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_PLAY_STATION_UID, GamesPlayStationUid))
#define GAMES_PLAY_STATION_UID_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_PLAY_STATION_UID, GamesPlayStationUidClass))
#define GAMES_IS_PLAY_STATION_UID(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_PLAY_STATION_UID))
#define GAMES_IS_PLAY_STATION_UID_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_PLAY_STATION_UID))
#define GAMES_PLAY_STATION_UID_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_PLAY_STATION_UID, GamesPlayStationUidClass))

typedef struct _GamesPlayStationUid GamesPlayStationUid;
typedef struct _GamesPlayStationUidClass GamesPlayStationUidClass;

struct _GamesPlayStationGameFactory {
	GObject parent_instance;
	GamesPlayStationGameFactoryPrivate * priv;
};

struct _GamesPlayStationGameFactoryClass {
	GObjectClass parent_class;
};

struct _GamesPlayStationGameFactoryPrivate {
	GHashTable* discs;
	GHashTable* disc_sets;
	GHashTable* games;
};

struct _Block1Data {
	int _ref_count_;
	GamesPlayStationGameFactory* self;
	GamesGameinfoDoc* gameinfo;
	GamesGameCallback game_callback;
	gpointer game_callback_target;
	gpointer _async_data_;
};

struct _GamesPlayStationGameFactoryForeachGameData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	gboolean _task_complete_;
	GamesPlayStationGameFactory* self;
	GamesGameCallback game_callback;
	gpointer game_callback_target;
	Block1Data* _data1_;
	GamesGameCallback _tmp0_;
	void* _tmp0__target;
	GamesGameinfoDoc* _tmp1_;
	GamesGameinfoDoc* _tmp2_;
	GamesGameinfoDoc* _tmp3_;
	GError* e;
	GError* _tmp4_;
	const gchar* _tmp5_;
	GHashTable* _tmp6_;
	GHashTable* _tmp7_;
	GHashTable* _tmp8_;
	GError * _inner_error_;
};

struct _Block2Data {
	int _ref_count_;
	GamesPlayStationGameFactory* self;
	GamesMedia** medias;
	gint medias_length1;
	gint _medias_size_;
	GamesGameinfoDoc* gameinfo;
};


static gpointer games_play_station_game_factory_parent_class = NULL;
static GamesGameinfoDoc* games_play_station_game_factory_gameinfo;
static GamesGameinfoDoc* games_play_station_game_factory_gameinfo = NULL;
static GamesUriGameFactoryIface * games_play_station_game_factory_games_uri_game_factory_parent_iface = NULL;
static GType games_play_station_game_factory_type_id = 0;

GType games_play_station_game_factory_get_type (void) G_GNUC_CONST;
#define GAMES_PLAY_STATION_GAME_FACTORY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GAMES_TYPE_PLAY_STATION_GAME_FACTORY, GamesPlayStationGameFactoryPrivate))
enum  {
	GAMES_PLAY_STATION_GAME_FACTORY_DUMMY_PROPERTY
};
#define GAMES_PLAY_STATION_GAME_FACTORY_SEARCHED_MIME_TYPE "application/x-cue"
#define GAMES_PLAY_STATION_GAME_FACTORY_SPECIFIC_MIME_TYPE "application/x-playstation-rom"
#define GAMES_PLAY_STATION_GAME_FACTORY_PLATFORM "PlayStation"
#define GAMES_PLAY_STATION_GAME_FACTORY_ICON_NAME "media-optical-symbolic"
#define GAMES_PLAY_STATION_GAME_FACTORY_GAMEINFO "resource:///org/gnome/Games/plugin/playstation/playstation.gameinfo.xm" \
"l"
GamesPlayStationGameFactory* games_play_station_game_factory_new (void);
GamesPlayStationGameFactory* games_play_station_game_factory_construct (GType object_type);
static void _g_free0_ (gpointer var);
static void _g_hash_table_unref0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
gboolean games_play_station_game_factory_is_cursor_valid (GamesPlayStationGameFactory* self, TrackerSparqlCursor* cursor);
static gboolean games_play_station_game_factory_real_is_uri_valid (GamesUriGameFactory* base, const gchar* uri);
static void games_play_station_game_factory_real_add_uri (GamesUriGameFactory* base, const gchar* uri);
static gchar* games_play_station_game_factory_get_disc_id (GamesPlayStationGameFactory* self, const gchar* uri, GError** error);
static void games_play_station_game_factory_real_foreach_game_data_free (gpointer _data);
static void games_play_station_game_factory_real_foreach_game (GamesUriGameFactory* base, GamesGameCallback game_callback, void* game_callback_target, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean games_play_station_game_factory_real_foreach_game_co (GamesPlayStationGameFactoryForeachGameData* _data_);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static GamesGameinfoDoc* games_play_station_game_factory_get_gameinfo (GError** error);
static void __lambda4_ (Block1Data* _data1_, const gchar* disc_id, const gchar* uri);
static void ___lambda4__gh_func (gconstpointer key, gconstpointer value, gpointer self);
static void __lambda5_ (GamesPlayStationGameFactory* self, const gchar* disc_set_id, GHashTable* disc_set);
static GamesGame* games_play_station_game_factory_game_for_disc_set (GamesPlayStationGameFactory* self, GHashTable* disc_set, GError** error);
static void ___lambda5__gh_func (gconstpointer key, gconstpointer value, gpointer self);
static void __lambda8_ (Block1Data* _data1_, const gchar* disc_set_id, GamesGame* game);
static void ___lambda8__gh_func (gconstpointer key, gconstpointer value, gpointer self);
GType games_play_station_header_get_type (void) G_GNUC_CONST;
GamesPlayStationHeader* games_play_station_header_new (GFile* file);
GamesPlayStationHeader* games_play_station_header_construct (GType object_type, GFile* file);
void games_play_station_header_check_validity (GamesPlayStationHeader* self, GError** error);
const gchar* games_play_station_header_get_disc_id (GamesPlayStationHeader* self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static gint __lambda6_ (Block2Data* _data2_, const gchar* disc_id_a, const gchar* disc_id_b);
static gint ___lambda6__gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self);
static void __lambda7_ (Block2Data* _data2_, const gchar* disc_id);
static void _vala_array_add1 (GamesMedia** * array, int* length, int* size, GamesMedia* value);
static void ___lambda7__gfunc (gconstpointer data, gpointer self);
static GamesGame* games_play_station_game_factory_game_for_uris (GamesPlayStationGameFactory* self, GamesMediaSet* media_set, GError** error);
GType games_play_station_uid_get_type (void) G_GNUC_CONST;
GamesPlayStationUid* games_play_station_uid_new (GamesPlayStationHeader* header);
GamesPlayStationUid* games_play_station_uid_construct (GType object_type, GamesPlayStationHeader* header);
static void games_play_station_game_factory_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_hash_table_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL));
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


GamesPlayStationGameFactory* games_play_station_game_factory_construct (GType object_type) {
	GamesPlayStationGameFactory * self = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GHashFunc _tmp3_;
	GEqualFunc _tmp4_;
	GHashTable* _tmp5_;
	GHashFunc _tmp6_;
	GEqualFunc _tmp7_;
	GHashTable* _tmp8_;
	self = (GamesPlayStationGameFactory*) g_object_new (object_type, NULL);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_free0_);
	_g_hash_table_unref0 (self->priv->discs);
	self->priv->discs = _tmp2_;
	_tmp3_ = g_str_hash;
	_tmp4_ = g_str_equal;
	_tmp5_ = g_hash_table_new_full (_tmp3_, _tmp4_, _g_free0_, _g_hash_table_unref0_);
	_g_hash_table_unref0 (self->priv->disc_sets);
	self->priv->disc_sets = _tmp5_;
	_tmp6_ = g_str_hash;
	_tmp7_ = g_str_equal;
	_tmp8_ = g_hash_table_new_full (_tmp6_, _tmp7_, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->games);
	self->priv->games = _tmp8_;
	return self;
}


GamesPlayStationGameFactory* games_play_station_game_factory_new (void) {
	return games_play_station_game_factory_construct (GAMES_TYPE_PLAY_STATION_GAME_FACTORY);
}


gboolean games_play_station_game_factory_is_cursor_valid (GamesPlayStationGameFactory* self, TrackerSparqlCursor* cursor) {
	gboolean result = FALSE;
	gchar* uri;
	TrackerSparqlCursor* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (cursor != NULL, FALSE);
	_tmp0_ = cursor;
	_tmp1_ = tracker_sparql_cursor_get_string (_tmp0_, 0, NULL);
	_tmp2_ = g_strdup (_tmp1_);
	uri = _tmp2_;
	_tmp3_ = games_uri_game_factory_is_uri_valid ((GamesUriGameFactory*) self, uri);
	result = _tmp3_;
	_g_free0 (uri);
	return result;
}


static gboolean games_play_station_game_factory_real_is_uri_valid (GamesUriGameFactory* base, const gchar* uri) {
	GamesPlayStationGameFactory * self;
	gboolean result = FALSE;
	GFile* file;
	const gchar* _tmp0_;
	GFile* _tmp1_;
	gboolean _tmp2_;
	self = (GamesPlayStationGameFactory*) base;
	g_return_val_if_fail (uri != NULL, FALSE);
	_tmp0_ = uri;
	_tmp1_ = g_file_new_for_uri (_tmp0_);
	file = _tmp1_;
	_tmp2_ = g_file_query_exists (file, NULL);
	result = _tmp2_;
	_g_object_unref0 (file);
	return result;
}


static void games_play_station_game_factory_real_add_uri (GamesUriGameFactory* base, const gchar* uri) {
	GamesPlayStationGameFactory * self;
	gchar* disc_id = NULL;
	GHashTable* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	GError * _inner_error_ = NULL;
	self = (GamesPlayStationGameFactory*) base;
	g_return_if_fail (uri != NULL);
	{
		gchar* _tmp0_;
		const gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp1_ = uri;
		_tmp2_ = games_play_station_game_factory_get_disc_id (self, _tmp1_, &_inner_error_);
		_tmp0_ = _tmp2_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		_g_free0 (disc_id);
		disc_id = _tmp3_;
		_g_free0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
		_g_free0 (disc_id);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (disc_id);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp4_ = self->priv->discs;
	_tmp5_ = disc_id;
	_tmp6_ = g_strdup (_tmp5_);
	_tmp7_ = uri;
	_tmp8_ = g_strdup (_tmp7_);
	g_hash_table_insert (_tmp4_, _tmp6_, _tmp8_);
	_g_free0 (disc_id);
}


static void games_play_station_game_factory_real_foreach_game_data_free (gpointer _data) {
	GamesPlayStationGameFactoryForeachGameData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (GamesPlayStationGameFactoryForeachGameData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void games_play_station_game_factory_real_foreach_game (GamesUriGameFactory* base, GamesGameCallback game_callback, void* game_callback_target, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GamesPlayStationGameFactory * self;
	GamesPlayStationGameFactoryForeachGameData* _data_;
	GamesPlayStationGameFactory* _tmp0_;
	GamesGameCallback _tmp1_;
	void* _tmp1__target;
	self = (GamesPlayStationGameFactory*) base;
	_data_ = g_slice_new0 (GamesPlayStationGameFactoryForeachGameData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, games_play_station_game_factory_real_foreach_game_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = game_callback;
	_tmp1__target = game_callback_target;
	_data_->game_callback = _tmp1_;
	_data_->game_callback_target = _tmp1__target;
	games_play_station_game_factory_real_foreach_game_co (_data_);
}


static void games_play_station_game_factory_real_foreach_game_finish (GamesUriGameFactory* base, GAsyncResult* _res_) {
	GamesPlayStationGameFactoryForeachGameData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	_data_->_task_complete_ = TRUE;
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		GamesPlayStationGameFactory* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->gameinfo);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}


static void __lambda4_ (Block1Data* _data1_, const gchar* disc_id, const gchar* uri) {
	GamesPlayStationGameFactory* self;
	gchar* disc_set_id;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GHashTable* _tmp9_;
	const gchar* _tmp10_;
	gboolean _tmp11_;
	GHashTable* _tmp18_;
	const gchar* _tmp19_;
	gconstpointer _tmp20_;
	const gchar* _tmp21_;
	gchar* _tmp22_;
	GError * _inner_error_ = NULL;
	self = _data1_->self;
	g_return_if_fail (disc_id != NULL);
	g_return_if_fail (uri != NULL);
	_tmp0_ = disc_id;
	_tmp1_ = g_strdup (_tmp0_);
	disc_set_id = _tmp1_;
	{
		GamesGameinfoDoc* _tmp2_;
		_tmp2_ = _data1_->gameinfo;
		if (_tmp2_ != NULL) {
			gchar* _tmp3_;
			GamesGameinfoDoc* _tmp4_;
			const gchar* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			_tmp4_ = _data1_->gameinfo;
			_tmp5_ = disc_id;
			_tmp6_ = games_gameinfo_doc_get_disc_set_id_for_disc_id (_tmp4_, _tmp5_, &_inner_error_);
			_tmp3_ = _tmp6_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch2_g_error;
			}
			_tmp7_ = _tmp3_;
			_tmp3_ = NULL;
			_g_free0 (disc_set_id);
			disc_set_id = _tmp7_;
			_g_free0 (_tmp3_);
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp8_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp8_ = disc_id;
		g_debug (_ ("Disc with disc_id %s is unknown"), _tmp8_);
		_g_error_free0 (e);
	}
	__finally2:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (disc_set_id);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp9_ = self->priv->disc_sets;
	_tmp10_ = disc_set_id;
	_tmp11_ = g_hash_table_contains (_tmp9_, _tmp10_);
	if (!_tmp11_) {
		GHashTable* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		GHashFunc _tmp15_;
		GEqualFunc _tmp16_;
		GHashTable* _tmp17_;
		_tmp12_ = self->priv->disc_sets;
		_tmp13_ = disc_set_id;
		_tmp14_ = g_strdup (_tmp13_);
		_tmp15_ = g_str_hash;
		_tmp16_ = g_str_equal;
		_tmp17_ = g_hash_table_new_full (_tmp15_, _tmp16_, NULL, _g_free0_);
		g_hash_table_insert (_tmp12_, _tmp14_, _tmp17_);
	}
	_tmp18_ = self->priv->disc_sets;
	_tmp19_ = disc_set_id;
	_tmp20_ = g_hash_table_lookup (_tmp18_, _tmp19_);
	_tmp21_ = disc_id;
	_tmp22_ = g_strdup (_tmp21_);
	g_hash_table_add ((GHashTable*) _tmp20_, _tmp22_);
	_g_free0 (disc_set_id);
}


static void ___lambda4__gh_func (gconstpointer key, gconstpointer value, gpointer self) {
	__lambda4_ (self, (const gchar*) key, (const gchar*) value);
}


static void __lambda5_ (GamesPlayStationGameFactory* self, const gchar* disc_set_id, GHashTable* disc_set) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (disc_set_id != NULL);
	g_return_if_fail (disc_set != NULL);
	{
		GHashTable* _tmp0_;
		const gchar* _tmp1_;
		gboolean _tmp2_;
		_tmp0_ = self->priv->games;
		_tmp1_ = disc_set_id;
		_tmp2_ = g_hash_table_contains (_tmp0_, _tmp1_);
		if (!_tmp2_) {
			GamesGame* _tmp3_;
			GHashTable* _tmp4_;
			GamesGame* _tmp5_;
			GHashTable* _tmp6_;
			const gchar* _tmp7_;
			gchar* _tmp8_;
			GamesGame* _tmp9_;
			_tmp4_ = disc_set;
			_tmp5_ = games_play_station_game_factory_game_for_disc_set (self, _tmp4_, &_inner_error_);
			_tmp3_ = _tmp5_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch3_g_error;
			}
			_tmp6_ = self->priv->games;
			_tmp7_ = disc_set_id;
			_tmp8_ = g_strdup (_tmp7_);
			_tmp9_ = _tmp3_;
			_tmp3_ = NULL;
			g_hash_table_insert (_tmp6_, _tmp8_, _tmp9_);
			_g_object_unref0 (_tmp3_);
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		GError* _tmp10_;
		const gchar* _tmp11_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp10_ = e;
		_tmp11_ = _tmp10_->message;
		g_warning ("playstation-game-factory.vala:80: %s", _tmp11_);
		_g_error_free0 (e);
	}
	__finally3:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void ___lambda5__gh_func (gconstpointer key, gconstpointer value, gpointer self) {
	__lambda5_ ((GamesPlayStationGameFactory*) self, (const gchar*) key, (GHashTable*) value);
}


static void __lambda8_ (Block1Data* _data1_, const gchar* disc_set_id, GamesGame* game) {
	GamesPlayStationGameFactory* self;
	GamesGameCallback _tmp0_;
	void* _tmp0__target;
	GamesGame* _tmp1_;
	self = _data1_->self;
	g_return_if_fail (disc_set_id != NULL);
	g_return_if_fail (game != NULL);
	_tmp0_ = _data1_->game_callback;
	_tmp0__target = _data1_->game_callback_target;
	_tmp1_ = game;
	_tmp0_ (_tmp1_, _tmp0__target);
}


static void ___lambda8__gh_func (gconstpointer key, gconstpointer value, gpointer self) {
	__lambda8_ (self, (const gchar*) key, (GamesGame*) value);
}


static gboolean games_play_station_game_factory_real_foreach_game_co (GamesPlayStationGameFactoryForeachGameData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data1_ = g_slice_new0 (Block1Data);
	_data_->_data1_->_ref_count_ = 1;
	_data_->_data1_->self = g_object_ref (_data_->self);
	_data_->_tmp0_ = _data_->game_callback;
	_data_->_tmp0__target = _data_->game_callback_target;
	_data_->_data1_->game_callback = _data_->_tmp0_;
	_data_->_data1_->game_callback_target = _data_->_tmp0__target;
	_data_->_data1_->_async_data_ = _data_;
	_data_->_data1_->gameinfo = NULL;
	{
		_data_->_tmp2_ = games_play_station_game_factory_get_gameinfo (&_data_->_inner_error_);
		_data_->_tmp1_ = _data_->_tmp2_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch1_g_error;
		}
		_data_->_tmp3_ = _data_->_tmp1_;
		_data_->_tmp1_ = NULL;
		_g_object_unref0 (_data_->_data1_->gameinfo);
		_data_->_data1_->gameinfo = _data_->_tmp3_;
		_g_object_unref0 (_data_->_tmp1_);
	}
	goto __finally1;
	__catch1_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp4_ = _data_->e;
		_data_->_tmp5_ = _data_->_tmp4_->message;
		g_warning ("playstation-game-factory.vala:54: %s", _data_->_tmp5_);
		_g_error_free0 (_data_->e);
	}
	__finally1:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		block1_data_unref (_data_->_data1_);
		_data_->_data1_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_data_->_tmp6_ = _data_->self->priv->discs;
	g_hash_table_foreach (_data_->_tmp6_, ___lambda4__gh_func, _data_->_data1_);
	_data_->_tmp7_ = _data_->self->priv->disc_sets;
	g_hash_table_foreach (_data_->_tmp7_, ___lambda5__gh_func, _data_->self);
	_data_->_tmp8_ = _data_->self->priv->games;
	g_hash_table_foreach (_data_->_tmp8_, ___lambda8__gh_func, _data_->_data1_);
	block1_data_unref (_data_->_data1_);
	_data_->_data1_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (_data_->_task_complete_ != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static gchar* games_play_station_game_factory_get_disc_id (GamesPlayStationGameFactory* self, const gchar* uri, GError** error) {
	gchar* result = NULL;
	GFile* cue_file;
	const gchar* _tmp0_;
	GFile* _tmp1_;
	GamesCueSheet* cue_sheet;
	GFile* _tmp2_;
	GamesCueSheet* _tmp3_;
	GamesCueSheetTrackNode* cue_track_node;
	GamesCueSheet* _tmp4_;
	GamesCueSheetTrackNode* _tmp5_;
	GFile* bin_file;
	GamesCueSheetTrackNode* _tmp6_;
	GamesCueSheetFileNode* _tmp7_;
	GamesCueSheetFileNode* _tmp8_;
	GFile* _tmp9_;
	GFile* _tmp10_;
	GFile* _tmp11_;
	GamesPlayStationHeader* header;
	GFile* _tmp12_;
	GamesPlayStationHeader* _tmp13_;
	GamesPlayStationHeader* _tmp14_;
	GamesPlayStationHeader* _tmp15_;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	_tmp0_ = uri;
	_tmp1_ = g_file_new_for_uri (_tmp0_);
	cue_file = _tmp1_;
	_tmp2_ = cue_file;
	_tmp3_ = games_cue_sheet_new (_tmp2_, &_inner_error_);
	cue_sheet = _tmp3_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (cue_file);
		return NULL;
	}
	_tmp4_ = cue_sheet;
	_tmp5_ = games_cue_sheet_get_track (_tmp4_, (guint) 0, &_inner_error_);
	cue_track_node = _tmp5_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (cue_sheet);
		_g_object_unref0 (cue_file);
		return NULL;
	}
	_tmp6_ = cue_track_node;
	_tmp7_ = games_cue_sheet_track_node_get_file (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = games_cue_sheet_file_node_get_file (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = _g_object_ref0 (_tmp10_);
	bin_file = _tmp11_;
	_tmp12_ = bin_file;
	_tmp13_ = games_play_station_header_new (_tmp12_);
	header = _tmp13_;
	_tmp14_ = header;
	games_play_station_header_check_validity (_tmp14_, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (header);
		_g_object_unref0 (bin_file);
		_g_object_unref0 (cue_track_node);
		_g_object_unref0 (cue_sheet);
		_g_object_unref0 (cue_file);
		return NULL;
	}
	_tmp15_ = header;
	_tmp16_ = games_play_station_header_get_disc_id (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = g_strdup (_tmp17_);
	result = _tmp18_;
	_g_object_unref0 (header);
	_g_object_unref0 (bin_file);
	_g_object_unref0 (cue_track_node);
	_g_object_unref0 (cue_sheet);
	_g_object_unref0 (cue_file);
	return result;
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		GamesPlayStationGameFactory* self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->gameinfo);
		_data2_->medias = (_vala_array_free (_data2_->medias, _data2_->medias_length1, (GDestroyNotify) g_object_unref), NULL);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}


static gint __lambda6_ (Block2Data* _data2_, const gchar* disc_id_a, const gchar* disc_id_b) {
	GamesPlayStationGameFactory* self;
	gint result = 0;
	gint index_a = 0;
	gint index_b = 0;
	gint _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	GError * _inner_error_ = NULL;
	self = _data2_->self;
	g_return_val_if_fail (disc_id_a != NULL, 0);
	g_return_val_if_fail (disc_id_b != NULL, 0);
	{
		gint _tmp0_;
		GamesGameinfoDoc* _tmp1_;
		const gchar* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		GamesGameinfoDoc* _tmp5_;
		const gchar* _tmp6_;
		gint _tmp7_;
		_tmp1_ = _data2_->gameinfo;
		_tmp2_ = disc_id_a;
		_tmp3_ = games_gameinfo_doc_get_disc_set_index_for_disc_id (_tmp1_, _tmp2_, &_inner_error_);
		_tmp0_ = _tmp3_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch4_g_error;
		}
		index_a = _tmp0_;
		_tmp5_ = _data2_->gameinfo;
		_tmp6_ = disc_id_b;
		_tmp7_ = games_gameinfo_doc_get_disc_set_index_for_disc_id (_tmp5_, _tmp6_, &_inner_error_);
		_tmp4_ = _tmp7_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch4_g_error;
		}
		index_b = _tmp4_;
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* e = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		g_debug ("playstation-game-factory.vala:114: %s", _tmp9_);
		result = 0;
		_g_error_free0 (e);
		return result;
	}
	__finally4:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gint _tmp10_ = 0;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return _tmp10_;
	}
	_tmp11_ = index_a;
	_tmp12_ = index_b;
	_tmp13_ = index_a;
	_tmp14_ = index_b;
	result = ((gint) (_tmp11_ > _tmp12_)) - ((gint) (_tmp13_ < _tmp14_));
	return result;
}


static gint ___lambda6__gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gint result;
	result = __lambda6_ (self, (const gchar*) a, (const gchar*) b);
	return result;
}


static void _vala_array_add1 (GamesMedia** * array, int* length, int* size, GamesMedia* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GamesMedia*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void __lambda7_ (Block2Data* _data2_, const gchar* disc_id) {
	GamesPlayStationGameFactory* self;
	gchar* uri;
	GHashTable* _tmp0_;
	const gchar* _tmp1_;
	gconstpointer _tmp2_;
	gchar* _tmp3_;
	GamesGameinfoDiscIdDiscTitle* title;
	GamesGameinfoDoc* _tmp4_;
	const gchar* _tmp5_;
	GamesGameinfoDiscIdDiscTitle* _tmp6_;
	GamesMedia** _tmp7_;
	gint _tmp7__length1;
	GamesMedia* _tmp8_;
	self = _data2_->self;
	g_return_if_fail (disc_id != NULL);
	_tmp0_ = self->priv->discs;
	_tmp1_ = disc_id;
	_tmp2_ = g_hash_table_lookup (_tmp0_, _tmp1_);
	_tmp3_ = g_strdup ((const gchar*) _tmp2_);
	uri = _tmp3_;
	_tmp4_ = _data2_->gameinfo;
	_tmp5_ = disc_id;
	_tmp6_ = games_gameinfo_disc_id_disc_title_new (_tmp4_, _tmp5_, NULL);
	title = _tmp6_;
	_tmp7_ = _data2_->medias;
	_tmp7__length1 = _data2_->medias_length1;
	_tmp8_ = games_media_new (uri, (GamesTitle*) title);
	_vala_array_add1 (&_data2_->medias, &_data2_->medias_length1, &_data2_->_medias_size_, _tmp8_);
	_g_object_unref0 (title);
	_g_free0 (uri);
}


static void ___lambda7__gfunc (gconstpointer data, gpointer self) {
	__lambda7_ (self, (const gchar*) data);
}


static GamesGame* games_play_station_game_factory_game_for_disc_set (GamesPlayStationGameFactory* self, GHashTable* disc_set, GError** error) {
	GamesGame* result = NULL;
	Block2Data* _data2_;
	GamesMedia** _tmp0_;
	GamesGameinfoDoc* _tmp1_;
	GList* disc_list;
	GHashTable* _tmp2_;
	GList* _tmp3_;
	GList* _tmp4_;
	GIcon* icon;
	GIcon* _tmp5_;
	GamesMediaSet* media_set;
	GamesMedia** _tmp6_;
	gint _tmp6__length1;
	GIcon* _tmp7_;
	GamesMediaSet* _tmp8_;
	GamesGame* game;
	GamesMediaSet* _tmp9_;
	GamesGame* _tmp10_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (disc_set != NULL, NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = g_new0 (GamesMedia*, 0 + 1);
	_data2_->medias = _tmp0_;
	_data2_->medias_length1 = 0;
	_data2_->_medias_size_ = _data2_->medias_length1;
	_tmp1_ = games_play_station_game_factory_get_gameinfo (&_inner_error_);
	_data2_->gameinfo = _tmp1_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		block2_data_unref (_data2_);
		_data2_ = NULL;
		return NULL;
	}
	_tmp2_ = disc_set;
	_tmp3_ = g_hash_table_get_values (_tmp2_);
	disc_list = _tmp3_;
	disc_list = g_list_sort_with_data (disc_list, ___lambda6__gcompare_data_func, _data2_);
	_tmp4_ = disc_list;
	g_list_foreach (_tmp4_, ___lambda7__gfunc, _data2_);
	_tmp5_ = g_icon_new_for_string (GAMES_PLAY_STATION_GAME_FACTORY_ICON_NAME, &_inner_error_);
	icon = _tmp5_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_list_free0 (disc_list);
		block2_data_unref (_data2_);
		_data2_ = NULL;
		return NULL;
	}
	_tmp6_ = _data2_->medias;
	_tmp6__length1 = _data2_->medias_length1;
	_tmp7_ = icon;
	_tmp8_ = games_media_set_new (_tmp6_, _tmp6__length1, _tmp7_);
	media_set = _tmp8_;
	_tmp9_ = media_set;
	_tmp10_ = games_play_station_game_factory_game_for_uris (self, _tmp9_, &_inner_error_);
	game = _tmp10_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (media_set);
		_g_object_unref0 (icon);
		_g_list_free0 (disc_list);
		block2_data_unref (_data2_);
		_data2_ = NULL;
		return NULL;
	}
	result = game;
	_g_object_unref0 (media_set);
	_g_object_unref0 (icon);
	_g_list_free0 (disc_list);
	block2_data_unref (_data2_);
	_data2_ = NULL;
	return result;
}


static GamesGame* games_play_station_game_factory_game_for_uris (GamesPlayStationGameFactory* self, GamesMediaSet* media_set, GError** error) {
	GamesGame* result = NULL;
	GamesMedia* _tmp0_;
	GamesMediaSet* _tmp1_;
	GamesMedia* _tmp2_;
	gchar* uri;
	GamesMedia* _tmp3_;
	GamesMedia* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GFile* cue_file;
	const gchar* _tmp9_;
	GFile* _tmp10_;
	GamesCueSheet* cue_sheet;
	GFile* _tmp11_;
	GamesCueSheet* _tmp12_;
	GamesCueSheetTrackNode* cue_track_node;
	GamesCueSheet* _tmp13_;
	GamesCueSheetTrackNode* _tmp14_;
	GFile* bin_file;
	GamesCueSheetTrackNode* _tmp15_;
	GamesCueSheetFileNode* _tmp16_;
	GamesCueSheetFileNode* _tmp17_;
	GFile* _tmp18_;
	GFile* _tmp19_;
	GFile* _tmp20_;
	GamesPlayStationHeader* header;
	GFile* _tmp21_;
	GamesPlayStationHeader* _tmp22_;
	GamesPlayStationHeader* _tmp23_;
	GamesGameinfoDoc* gameinfo;
	GamesGameinfoDoc* _tmp24_;
	GamesPlayStationUid* uid;
	GamesPlayStationHeader* _tmp25_;
	GamesPlayStationUid* _tmp26_;
	GamesCompositeTitle* title;
	GamesGameinfoDoc* _tmp27_;
	GamesPlayStationHeader* _tmp28_;
	const gchar* _tmp29_;
	const gchar* _tmp30_;
	GamesGameinfoDiscIdGameTitle* _tmp31_;
	const gchar* _tmp32_;
	GamesFilenameTitle* _tmp33_;
	GamesTitle** _tmp34_;
	GamesTitle** _tmp35_;
	gint _tmp35__length1;
	GamesCompositeTitle* _tmp36_;
	GamesCompositeTitle* _tmp37_;
	GamesDummyIcon* icon;
	GamesDummyIcon* _tmp38_;
	GamesGriloMedia* media;
	GamesCompositeTitle* _tmp39_;
	GamesGriloMedia* _tmp40_;
	GamesCompositeCover* cover;
	const gchar* _tmp41_;
	GamesLocalCover* _tmp42_;
	GamesGriloMedia* _tmp43_;
	GamesPlayStationUid* _tmp44_;
	GamesGriloCover* _tmp45_;
	GamesCover** _tmp46_;
	GamesCover** _tmp47_;
	gint _tmp47__length1;
	GamesCompositeCover* _tmp48_;
	GamesCompositeCover* _tmp49_;
	GamesGameinfoDiscIdInputCapabilities* input_capabilities;
	GamesGameinfoDoc* _tmp50_;
	GamesPlayStationHeader* _tmp51_;
	const gchar* _tmp52_;
	const gchar* _tmp53_;
	GamesGameinfoDiscIdInputCapabilities* _tmp54_;
	GamesRetroCoreSource* core_source;
	gchar* _tmp55_;
	gchar* _tmp56_;
	gchar** _tmp57_;
	gchar** _tmp58_;
	gint _tmp58__length1;
	GamesRetroCoreSource* _tmp59_;
	GamesRetroCoreSource* _tmp60_;
	GamesRetroRunner* runner;
	GamesRetroCoreSource* _tmp61_;
	GamesMediaSet* _tmp62_;
	GamesPlayStationUid* _tmp63_;
	GamesGameinfoDiscIdInputCapabilities* _tmp64_;
	GamesCompositeTitle* _tmp65_;
	GamesRetroRunner* _tmp66_;
	GamesCompositeTitle* _tmp67_;
	GamesDummyIcon* _tmp68_;
	GamesCompositeCover* _tmp69_;
	GamesRetroRunner* _tmp70_;
	GamesGenericGame* _tmp71_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (media_set != NULL, NULL);
	_tmp1_ = media_set;
	_tmp2_ = games_media_set_get_selected_media (_tmp1_, (guint) 0, &_inner_error_);
	_tmp0_ = _tmp2_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	_tmp3_ = _tmp0_;
	_tmp0_ = NULL;
	_tmp4_ = _tmp3_;
	_tmp5_ = games_media_get_uri (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strdup (_tmp6_);
	_tmp8_ = _tmp7_;
	_g_object_unref0 (_tmp4_);
	uri = _tmp8_;
	_tmp9_ = uri;
	_tmp10_ = g_file_new_for_uri (_tmp9_);
	cue_file = _tmp10_;
	_tmp11_ = cue_file;
	_tmp12_ = games_cue_sheet_new (_tmp11_, &_inner_error_);
	cue_sheet = _tmp12_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (cue_file);
		_g_free0 (uri);
		_g_object_unref0 (_tmp0_);
		return NULL;
	}
	_tmp13_ = cue_sheet;
	_tmp14_ = games_cue_sheet_get_track (_tmp13_, (guint) 0, &_inner_error_);
	cue_track_node = _tmp14_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (cue_sheet);
		_g_object_unref0 (cue_file);
		_g_free0 (uri);
		_g_object_unref0 (_tmp0_);
		return NULL;
	}
	_tmp15_ = cue_track_node;
	_tmp16_ = games_cue_sheet_track_node_get_file (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = games_cue_sheet_file_node_get_file (_tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = _g_object_ref0 (_tmp19_);
	bin_file = _tmp20_;
	_tmp21_ = bin_file;
	_tmp22_ = games_play_station_header_new (_tmp21_);
	header = _tmp22_;
	_tmp23_ = header;
	games_play_station_header_check_validity (_tmp23_, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (header);
		_g_object_unref0 (bin_file);
		_g_object_unref0 (cue_track_node);
		_g_object_unref0 (cue_sheet);
		_g_object_unref0 (cue_file);
		_g_free0 (uri);
		_g_object_unref0 (_tmp0_);
		return NULL;
	}
	_tmp24_ = games_play_station_game_factory_get_gameinfo (&_inner_error_);
	gameinfo = _tmp24_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (header);
		_g_object_unref0 (bin_file);
		_g_object_unref0 (cue_track_node);
		_g_object_unref0 (cue_sheet);
		_g_object_unref0 (cue_file);
		_g_free0 (uri);
		_g_object_unref0 (_tmp0_);
		return NULL;
	}
	_tmp25_ = header;
	_tmp26_ = games_play_station_uid_new (_tmp25_);
	uid = _tmp26_;
	_tmp27_ = gameinfo;
	_tmp28_ = header;
	_tmp29_ = games_play_station_header_get_disc_id (_tmp28_);
	_tmp30_ = _tmp29_;
	_tmp31_ = games_gameinfo_disc_id_game_title_new (_tmp27_, _tmp30_, NULL);
	_tmp32_ = uri;
	_tmp33_ = games_filename_title_new (_tmp32_);
	_tmp34_ = g_new0 (GamesTitle*, 2 + 1);
	_tmp34_[0] = (GamesTitle*) _tmp31_;
	_tmp34_[1] = (GamesTitle*) _tmp33_;
	_tmp35_ = _tmp34_;
	_tmp35__length1 = 2;
	_tmp36_ = games_composite_title_new (_tmp35_, 2);
	_tmp37_ = _tmp36_;
	_tmp35_ = (_vala_array_free (_tmp35_, _tmp35__length1, (GDestroyNotify) g_object_unref), NULL);
	title = _tmp37_;
	_tmp38_ = games_dummy_icon_new ();
	icon = _tmp38_;
	_tmp39_ = title;
	_tmp40_ = games_grilo_media_new ((GamesTitle*) _tmp39_, GAMES_PLAY_STATION_GAME_FACTORY_SPECIFIC_MIME_TYPE);
	media = _tmp40_;
	_tmp41_ = uri;
	_tmp42_ = games_local_cover_new (_tmp41_);
	_tmp43_ = media;
	_tmp44_ = uid;
	_tmp45_ = games_grilo_cover_new (_tmp43_, (GamesUid*) _tmp44_);
	_tmp46_ = g_new0 (GamesCover*, 2 + 1);
	_tmp46_[0] = (GamesCover*) _tmp42_;
	_tmp46_[1] = (GamesCover*) _tmp45_;
	_tmp47_ = _tmp46_;
	_tmp47__length1 = 2;
	_tmp48_ = games_composite_cover_new (_tmp47_, 2);
	_tmp49_ = _tmp48_;
	_tmp47_ = (_vala_array_free (_tmp47_, _tmp47__length1, (GDestroyNotify) g_object_unref), NULL);
	cover = _tmp49_;
	_tmp50_ = gameinfo;
	_tmp51_ = header;
	_tmp52_ = games_play_station_header_get_disc_id (_tmp51_);
	_tmp53_ = _tmp52_;
	_tmp54_ = games_gameinfo_disc_id_input_capabilities_new (_tmp50_, _tmp53_);
	input_capabilities = _tmp54_;
	_tmp55_ = g_strdup (GAMES_PLAY_STATION_GAME_FACTORY_SEARCHED_MIME_TYPE);
	_tmp56_ = g_strdup (GAMES_PLAY_STATION_GAME_FACTORY_SPECIFIC_MIME_TYPE);
	_tmp57_ = g_new0 (gchar*, 2 + 1);
	_tmp57_[0] = _tmp55_;
	_tmp57_[1] = _tmp56_;
	_tmp58_ = _tmp57_;
	_tmp58__length1 = 2;
	_tmp59_ = games_retro_core_source_new (GAMES_PLAY_STATION_GAME_FACTORY_PLATFORM, _tmp58_, 2);
	_tmp60_ = _tmp59_;
	_tmp58_ = (_vala_array_free (_tmp58_, _tmp58__length1, (GDestroyNotify) g_free), NULL);
	core_source = _tmp60_;
	_tmp61_ = core_source;
	_tmp62_ = media_set;
	_tmp63_ = uid;
	_tmp64_ = input_capabilities;
	_tmp65_ = title;
	_tmp66_ = games_retro_runner_new_for_media_set_and_input_capabilities (_tmp61_, _tmp62_, (GamesUid*) _tmp63_, (GamesInputCapabilities*) _tmp64_, (GamesTitle*) _tmp65_);
	runner = _tmp66_;
	_tmp67_ = title;
	_tmp68_ = icon;
	_tmp69_ = cover;
	_tmp70_ = runner;
	_tmp71_ = games_generic_game_new ((GamesTitle*) _tmp67_, (GamesIcon*) _tmp68_, (GamesCover*) _tmp69_, (GamesRunner*) _tmp70_);
	result = (GamesGame*) _tmp71_;
	_g_object_unref0 (runner);
	_g_object_unref0 (core_source);
	_g_object_unref0 (input_capabilities);
	_g_object_unref0 (cover);
	_g_object_unref0 (media);
	_g_object_unref0 (icon);
	_g_object_unref0 (title);
	_g_object_unref0 (uid);
	_g_object_unref0 (gameinfo);
	_g_object_unref0 (header);
	_g_object_unref0 (bin_file);
	_g_object_unref0 (cue_track_node);
	_g_object_unref0 (cue_sheet);
	_g_object_unref0 (cue_file);
	_g_free0 (uri);
	_g_object_unref0 (_tmp0_);
	return result;
}


static GamesGameinfoDoc* games_play_station_game_factory_get_gameinfo (GError** error) {
	GamesGameinfoDoc* result = NULL;
	GamesGameinfoDoc* _tmp0_;
	GFile* file;
	GFile* _tmp3_;
	GFileInputStream* input_stream;
	GFile* _tmp4_;
	GFileInputStream* _tmp5_;
	GFileInputStream* _tmp6_;
	gint64 length;
	GFileInputStream* _tmp7_;
	gint64 _tmp8_;
	GFileInputStream* _tmp9_;
	guint8* buffer;
	gint64 _tmp10_;
	guint8* _tmp11_;
	gint buffer_length1;
	gint _buffer_size_;
	gsize size;
	GFileInputStream* _tmp12_;
	guint8* _tmp13_;
	gint _tmp13__length1;
	gsize _tmp14_ = 0UL;
	GamesGameinfoDoc* _tmp15_;
	guint8* _tmp16_;
	gint _tmp16__length1;
	GamesGameinfoDoc* _tmp17_;
	GamesGameinfoDoc* _tmp18_;
	GamesGameinfoDoc* _tmp19_;
	GamesGameinfoDoc* _tmp20_;
	GError * _inner_error_ = NULL;
	_tmp0_ = games_play_station_game_factory_gameinfo;
	if (_tmp0_ != NULL) {
		GamesGameinfoDoc* _tmp1_;
		GamesGameinfoDoc* _tmp2_;
		_tmp1_ = games_play_station_game_factory_gameinfo;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = g_file_new_for_uri (GAMES_PLAY_STATION_GAME_FACTORY_GAMEINFO);
	file = _tmp3_;
	_tmp4_ = file;
	_tmp5_ = g_file_read (_tmp4_, NULL, &_inner_error_);
	input_stream = _tmp5_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (file);
		return NULL;
	}
	_tmp6_ = input_stream;
	G_FILE_INPUT_STREAM_GET_CLASS (_tmp6_)->seek (_tmp6_, (gint64) 0, G_SEEK_END, NULL, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (input_stream);
		_g_object_unref0 (file);
		return NULL;
	}
	_tmp7_ = input_stream;
	_tmp8_ = G_FILE_INPUT_STREAM_GET_CLASS (_tmp7_)->tell (_tmp7_);
	length = _tmp8_;
	_tmp9_ = input_stream;
	G_FILE_INPUT_STREAM_GET_CLASS (_tmp9_)->seek (_tmp9_, (gint64) 0, G_SEEK_SET, NULL, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (input_stream);
		_g_object_unref0 (file);
		return NULL;
	}
	_tmp10_ = length;
	_tmp11_ = g_new0 (guint8, _tmp10_);
	buffer = _tmp11_;
	buffer_length1 = _tmp10_;
	_buffer_size_ = buffer_length1;
	size = (gsize) 0;
	_tmp12_ = input_stream;
	_tmp13_ = buffer;
	_tmp13__length1 = buffer_length1;
	g_input_stream_read_all ((GInputStream*) _tmp12_, _tmp13_, (gsize) _tmp13__length1, &_tmp14_, NULL, &_inner_error_);
	size = _tmp14_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		buffer = (g_free (buffer), NULL);
		_g_object_unref0 (input_stream);
		_g_object_unref0 (file);
		return NULL;
	}
	_tmp16_ = buffer;
	_tmp16__length1 = buffer_length1;
	_tmp17_ = games_gameinfo_doc_new_from_data (_tmp16_, _tmp16__length1, &_inner_error_);
	_tmp15_ = _tmp17_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		buffer = (g_free (buffer), NULL);
		_g_object_unref0 (input_stream);
		_g_object_unref0 (file);
		return NULL;
	}
	_tmp18_ = _tmp15_;
	_tmp15_ = NULL;
	_g_object_unref0 (games_play_station_game_factory_gameinfo);
	games_play_station_game_factory_gameinfo = _tmp18_;
	_tmp19_ = games_play_station_game_factory_gameinfo;
	_tmp20_ = _g_object_ref0 (_tmp19_);
	result = _tmp20_;
	_g_object_unref0 (_tmp15_);
	buffer = (g_free (buffer), NULL);
	_g_object_unref0 (input_stream);
	_g_object_unref0 (file);
	return result;
}


static void games_play_station_game_factory_class_init (GamesPlayStationGameFactoryClass * klass) {
	games_play_station_game_factory_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GamesPlayStationGameFactoryPrivate));
	G_OBJECT_CLASS (klass)->finalize = games_play_station_game_factory_finalize;
}


static void games_play_station_game_factory_games_uri_game_factory_interface_init (GamesUriGameFactoryIface * iface) {
	games_play_station_game_factory_games_uri_game_factory_parent_iface = g_type_interface_peek_parent (iface);
	iface->is_uri_valid = (gboolean (*) (GamesUriGameFactory *, const gchar*)) games_play_station_game_factory_real_is_uri_valid;
	iface->add_uri = (void (*) (GamesUriGameFactory *, const gchar*)) games_play_station_game_factory_real_add_uri;
	iface->foreach_game = (void (*) (GamesUriGameFactory *, GamesGameCallback, void*)) games_play_station_game_factory_real_foreach_game;
	iface->foreach_game_finish = games_play_station_game_factory_real_foreach_game_finish;
}


static void games_play_station_game_factory_instance_init (GamesPlayStationGameFactory * self) {
	self->priv = GAMES_PLAY_STATION_GAME_FACTORY_GET_PRIVATE (self);
}


static void games_play_station_game_factory_finalize (GObject * obj) {
	GamesPlayStationGameFactory * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_PLAY_STATION_GAME_FACTORY, GamesPlayStationGameFactory);
	_g_hash_table_unref0 (self->priv->discs);
	_g_hash_table_unref0 (self->priv->disc_sets);
	_g_hash_table_unref0 (self->priv->games);
	G_OBJECT_CLASS (games_play_station_game_factory_parent_class)->finalize (obj);
}


GType games_play_station_game_factory_get_type (void) {
	return games_play_station_game_factory_type_id;
}


GType games_play_station_game_factory_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (GamesPlayStationGameFactoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_play_station_game_factory_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesPlayStationGameFactory), 0, (GInstanceInitFunc) games_play_station_game_factory_instance_init, NULL };
	static const GInterfaceInfo games_uri_game_factory_info = { (GInterfaceInitFunc) games_play_station_game_factory_games_uri_game_factory_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	games_play_station_game_factory_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "GamesPlayStationGameFactory", &g_define_type_info, 0);
	g_type_module_add_interface (module, games_play_station_game_factory_type_id, GAMES_TYPE_URI_GAME_FACTORY, &games_uri_game_factory_info);
	return games_play_station_game_factory_type_id;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



